package de.fhdw.wtf.persistence.exception;

import java.sql.SQLException;

/**
 * Wrapper for an Unnamed SQL-Exception. It contains a nested SQL-Exception
 * 
 */
public class OtherSQLException extends PersistenceException {
	/**
	 * the message of the exception.
	 */
	private static final String EXCEPTION_MESSAGE =
			"An exceptional behavior during contacting the Database occured, Please see full stack trace";
	
	/**
	 * Wrapper for a SQLException.
	 * 
	 * @param nestedException
	 *            the SQLException.
	 */
	public OtherSQLException(final SQLException nestedException) {
		super(EXCEPTION_MESSAGE + ": " + nestedException.getMessage(), nestedException);
	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
}
