package de.fhdw.wtf.persistence.meta;

public class User {
	
	private final long id;
	private final String name;
	private final String mandantId;
	
	public User(final long id, final String name, final String mandantId) {
		super();
		this.id = id;
		this.name = name;
		this.mandantId = mandantId;
	}
	
	public long getId() {
		return this.id;
	}
	
	public String getName() {
		return this.name;
	}
	
	public String getMandantId() {
		return this.mandantId;
	}
	
	@Override
	public boolean equals(final java.lang.Object obj) {
		if (obj instanceof User) {
			final User other = (User) obj;
			return this.id == other.id;
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		return (int) this.id;
	}
	
}
