/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.InitializingDatabaseContractViolationException;
import de.fhdw.wtf.persistence.exception.OtherSQLException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.SpecializationCycleDetected;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.IDManager;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.facade.TypeManagerImplementation;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.IntegerType;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.StringType;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserType;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class OracleClassFacadeImplementation
implements ClassFacade {
    private boolean initialized;
    private TypeManagerImplementation typeManager;
    private final OracleDatabaseManager database;

    public OracleClassFacadeImplementation(OracleDatabaseManager database) {
        this.database = database;
        this.initialized = false;
        this.typeManager = TypeManagerImplementation.getInstance();
    }

    @Override
    public UserType createUserType(String name, boolean abs, boolean transaction) throws PersistenceException {
        UserType result = new UserType(IDManager.instance().pullNextUnusedTypeID(name), name, abs, transaction);
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.createUserType(?,?,?,?); end;");){
            call.setLong(1, result.getId());
            call.setString(2, result.getName());
            call.setInt(3, result.isAbs() ? 1 : 0);
            call.setInt(4, result.isTrans() ? 1 : 0);
            call.execute();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.typeManager.saveType(result);
        return result;
    }

    @Override
    public UnidirectionalAssociation createUnidirectionalAssociation(String name, boolean essential, boolean unique, UserType owner, Type target) throws PersistenceException {
        UnidirectionalAssociation result = new UnidirectionalAssociation(IDManager.instance().pullNextUnusedAssociationID(name), name, owner, target, essential, unique);
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.createUnidirAssociation(?,?,?,?,?,?); end;");){
            call.setLong(1, result.getId());
            call.setString(2, result.getName());
            call.setLong(3, result.getOwner().getId());
            call.setLong(4, result.getTarget().getId());
            call.setInt(5, result.isEssential() ? 1 : 0);
            call.setInt(6, result.isUnique() ? 1 : 0);
            call.execute();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.typeManager.saveAssociation(result);
        return result;
    }

    @Override
    public MapAssociation createMapAssociation(String name, boolean essential, UserType owner, Type target, Type keyType) throws PersistenceException {
        MapAssociation result = new MapAssociation(IDManager.instance().pullNextUnusedAssociationID(name), name, owner, target, keyType, essential);
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.createMapAssociation(?,?,?,?,?,?,?); end;");){
            call.setLong(1, result.getId());
            call.setString(2, result.getName());
            call.setLong(3, result.getOwner().getId());
            call.setLong(4, result.getTarget().getId());
            call.setInt(5, result.isEssential() ? 1 : 0);
            call.setInt(6, 1);
            call.setLong(7, result.getKeyType().getId());
            call.execute();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.typeManager.saveAssociation(result);
        return result;
    }

    @Override
    public void createSpecializationBetween(UserType ancestor, Type descendant) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.createSpecialization(?,?); end;");){
            call.setLong(1, ancestor.getId());
            call.setLong(2, descendant.getId());
            call.execute();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void initialize() throws PersistenceException {
        Throwable throwable;
        CallableStatement call;
        try {
            call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.initialize; end;");
            throwable = null;
            try {
                call.execute();
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (call != null) {
                    if (throwable != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            call = this.database.getConnection().prepareCall("begin ? :=" + this.database.getSchemaName() + ".classfacade.getMaxIdFromType; end;");
            throwable = null;
            try {
                call.registerOutParameter(1, 2);
                call.execute();
                if (IDManager.getMaxBaseTypeID() != call.getLong(1)) {
                    throw new InitializingDatabaseContractViolationException();
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (call != null) {
                    if (throwable != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            call = this.database.getConnection().prepareCall("begin ? :=" + this.database.getSchemaName() + ".classfacade.getMaxIdFromAssociation; end;");
            throwable = null;
            try {
                call.registerOutParameter(1, 2);
                call.execute();
                if (IDManager.getMaxAssociationContractID() != call.getLong(1)) {
                    throw new InitializingDatabaseContractViolationException();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (call != null) {
                    if (throwable != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.initializeBaseTypes();
        this.finalizeSpecialization();
        this.initialized = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSuperClassTo(Type ancestor, Type descendant) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin ?:=" + this.database.getSchemaName() + ".classfacade.isSuperclassTo(?,?); end;");){
            call.registerOutParameter(1, 2);
            call.setLong(2, ancestor.getId());
            call.setLong(3, descendant.getId());
            call.execute();
            boolean bl = call.getInt(1) == 1;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void clear() throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.clearAll; end;");){
            call.execute();
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void finalizeSpecialization() throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.finalizeSpecialization; end;");){
            call.execute();
        }
        catch (SQLException e) {
            if ((long)e.getErrorCode() == 20000L) {
                throw new SpecializationCycleDetected(e);
            }
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void renameType(Long typeId, String newName) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.renameType(?,?); end;");){
            call.setLong(1, (long)typeId);
            call.setString(2, newName);
            call.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void renameAssociation(Long associationId, String newName) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.renameAssociation(?,?); end;");){
            call.setLong(1, (long)associationId);
            call.setString(2, newName);
            call.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void deleteAssociation(Long assoId) throws PersistenceException {
        this.typeManager.deleteAssociation(assoId);
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.deleteAssociation(?); end;");){
            call.setLong(1, (long)assoId);
            call.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void updateLinksToNewAssociation(Long associationId, Collection<Long> newAssociationIds) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.pushDownLinks(?,?); end;");){
            call.setLong(1, (long)associationId);
            ArrayDescriptor des = ArrayDescriptor.createDescriptor((String)(this.database.getSchemaName().toUpperCase() + ".ARRAY_INT"), (Connection)this.database.getConnection());
            Long[] newAssos = newAssociationIds.toArray(new Long[newAssociationIds.size()]);
            ARRAY arrayNewAssociation = new ARRAY(des, this.database.getConnection(), (Object)newAssos);
            call.setArray(2, (Array)arrayNewAssociation);
            call.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void deleteUserType(Long typeId) throws PersistenceException {
        this.typeManager.deleteType(typeId);
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.deleteUserTypeAndSpec(?); end;");){
            call.setLong(1, (long)typeId);
            call.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public void moveLinksAndCreateObjects(List<Long> oldAssoIds, Association newAsso, UserType newType, List<Long> newAssoIds) throws PersistenceException {
        try (CallableStatement call = this.database.getConnection().prepareCall("begin " + this.database.getSchemaName() + ".classfacade.moveLinksAndCreateObjects(?,?,?,?); end;");){
            ArrayDescriptor des = ArrayDescriptor.createDescriptor((String)(this.database.getSchemaName().toUpperCase() + ".ARRAY_INT"), (Connection)this.database.getConnection());
            Long[] oldAssosA = oldAssoIds.toArray(new Long[oldAssoIds.size()]);
            Long[] newAssosA = newAssoIds.toArray(new Long[newAssoIds.size()]);
            ARRAY arrayNewAssociations = new ARRAY(des, this.database.getConnection(), (Object)newAssosA);
            ARRAY arrayOldAssociations = new ARRAY(des, this.database.getConnection(), (Object)oldAssosA);
            call.setArray(1, (Array)arrayOldAssociations);
            call.setLong(2, newAsso.getId());
            call.setLong(3, newType.getId());
            call.setArray(4, (Array)arrayNewAssociations);
            call.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OtherSQLException(e);
        }
    }

    @Override
    public TypeManager getTypeManager() throws ClassFacadeUninitializedException {
        if (!this.hasBeenInitialized()) {
            throw new ClassFacadeUninitializedException();
        }
        return this.typeManager;
    }

    private void initializeBaseTypes() {
        this.typeManager.saveType(StringType.getInstance());
        this.typeManager.saveType(IntegerType.getInstance());
    }

    private boolean checkIfStringIsCorrect(Collection<Type> types) {
        Iterator<Type> i = types.iterator();
        while (i.hasNext()) {
            Type current = i.next();
            if (current.getId() != 1L || !current.getName().equals("String")) continue;
            i.remove();
            return true;
        }
        return false;
    }

    private boolean checkIfIntegerIsCorrect(Collection<Type> types) {
        Iterator<Type> i = types.iterator();
        while (i.hasNext()) {
            Type current = i.next();
            if (current.getId() != 2L || !current.getName().equals("Integer")) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.initialized;
    }

    @Override
    public void initializeForRuntime() throws PersistenceException {
        ResultSet result;
        Throwable throwable;
        CallableStatement call;
        this.typeManager = TypeManagerImplementation.getInstance();
        Vector<Type> types = new Vector<Type>();
        try {
            call = this.database.getConnection().prepareCall("begin ?:= " + this.database.getSchemaName() + ".classfacade.getAllTypes; end;");
            throwable = null;
            try {
                call.registerOutParameter(1, -10);
                call.execute();
                try (ResultSet result2 = ((OracleCallableStatement)call).getCursor(1);){
                    while (result2.next()) {
                        types.add(new UserType(result2.getLong(1), result2.getString(2), result2.getInt(3) == 1, result2.getInt(4) == 1));
                    }
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (call != null) {
                    if (throwable != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        if (!this.checkIfStringIsCorrect(types)) {
            throw new InitializingDatabaseContractViolationException();
        }
        if (!this.checkIfIntegerIsCorrect(types)) {
            throw new InitializingDatabaseContractViolationException();
        }
        this.initializeBaseTypes();
        for (Type t : types) {
            this.typeManager.saveType(t);
        }
        try {
            call = this.database.getConnection().prepareCall("begin ?:= " + this.database.getSchemaName() + ".classfacade.getAllUnidirAssociations; end;");
            throwable = null;
            try {
                call.registerOutParameter(1, -10);
                call.execute();
                Vector<UnidirectionalAssociation> unidirectionalAssociations = new Vector<UnidirectionalAssociation>();
                result = ((OracleCallableStatement)call).getCursor(1);
                Throwable throwable2 = null;
                try {
                    while (result.next()) {
                        unidirectionalAssociations.add(new UnidirectionalAssociation(result.getLong(1), result.getString(2), (UserType)this.typeManager.getTypeForId(result.getLong(3)), this.typeManager.getTypeForId(result.getLong(4)), result.getInt(5) == 1, result.getInt(6) == 1));
                    }
                }
                catch (Throwable x22) {
                    Throwable throwable3 = x22;
                    throw x22;
                }
                finally {
                    if (result != null) {
                        if (throwable2 != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable x22) {
                                throwable2.addSuppressed(x22);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
                for (UnidirectionalAssociation unidirectionalAssociation : unidirectionalAssociations) {
                    this.typeManager.saveAssociation(unidirectionalAssociation);
                }
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (call != null) {
                    if (throwable != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        try {
            call = this.database.getConnection().prepareCall("begin ?:= " + this.database.getSchemaName() + ".classfacade.getAllMapAssociations; end;");
            throwable = null;
            try {
                call.registerOutParameter(1, -10);
                call.execute();
                Vector<MapAssociation> mapAssociations = new Vector<MapAssociation>();
                result = ((OracleCallableStatement)call).getCursor(1);
                Throwable throwable4 = null;
                try {
                    while (result.next()) {
                        mapAssociations.add(new MapAssociation(result.getLong(1), result.getString(2), (UserType)this.typeManager.getTypeForId(result.getLong(3)), this.typeManager.getTypeForId(result.getLong(4)), this.typeManager.getTypeForId(result.getLong(5)), result.getInt(6) == 1));
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable6 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (result != null) {
                        if (throwable4 != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable x2) {
                                throwable4.addSuppressed(x2);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
                for (MapAssociation mapAssociation : mapAssociations) {
                    this.typeManager.saveAssociation(mapAssociation);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (call != null) {
                    if (throwable != null) {
                        try {
                            call.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        call.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new OtherSQLException(e);
        }
        this.initialized = true;
    }
}

