CREATE OR REPLACE PACKAGE BODY Accountfacade IS

FUNCTION doesRoleExist(n VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT count(*) INTO result FROM roles r
		WHERE r.name=n;
	RETURN result;
END;

FUNCTION doesUserExist(m VARCHAR2, u VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT count(*) INTO RESULT FROM accounts a
		WHERE a.mandant=m AND a.username =u;
	RETURN result;
END;


FUNCTION createUser(mandant VARCHAR2,username VARCHAR2,passwd VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	IF(doesUserExist(mandant,username)=1) THEN
		RAISE userexception.name_already_exists_exception;
    END IF;
    SELECT accounts_seq.nextval INTO result FROM dual;
		INSERT INTO accounts(id, mandant, username, passwd) VALUES(result, mandant, username, passwd);
	RETURN result;
END;

FUNCTION createRole(name VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	IF (doesRoleExist(name)=1) THEN
		RAISE userexception.name_already_exists_exception;
	END IF;
	SELECT roles_seq.nextval INTO RESULT FROM dual;
		INSERT INTO roles(id, name) VALUES(result, name);
	RETURN result;
END;

PROCEDURE addRoleToUser(user_id NUMBER, role_id NUMBER) IS
    nextId NUMBER;
BEGIN
	SELECT account_roles_seq.nextval INTO nextId FROM dual;
		INSERT INTO account_roles(id, account_id, role_id) VALUES(nextId, user_id, role_id);
END;

FUNCTION authorize(m VARCHAR2,u VARCHAR2, p VARCHAR2) RETURN NUMBER IS
    result NUMBER;
BEGIN
	SELECT count(*) INTO result FROM accounts a 
		WHERE a.mandant=m AND a.username=u AND a.passwd=p;
	RETURN result;
END;

FUNCTION getRoles(m VARCHAR2, u VARCHAR2) RETURN roleRecordCursor IS
    result roleRecordCursor;
BEGIN
	OPEN result FOR 
		SELECT r.id, r.name FROM roles r
			INNER JOIN account_roles ar on ar.role_id=r.id 
			INNER JOIN accounts a on a.id=ar.account_id
		WHERE a.mandant=m AND a.username=u;
		RETURN result;
END;

FUNCTION getAllUsersForMandant(m VARCHAR2) RETURN userRecordCursor IS
	result userRecordCursor;
BEGIN
	OPEN result FOR
		SELECT id,mandant,username FROM accounts a 
			WHERE a.mandant=m;
		RETURN result;
END;

FUNCTION getUser(m VARCHAR2, u VARCHAR2) RETURN userRecordCursor IS
	result userRecordCursor;
BEGIN
	OPEN result FOR
		SELECT id,mandant,username FROM accounts a
			WHERE a.mandant=m AND a.username=u;
		RETURN result;
END;

FUNCTION getRoleId(role_name VARCHAR2) RETURN NUMBER IS
	result NUMBER;
BEGIN
	SELECT id INTO result FROM roles r
		WHERE r.name=role_name;
	RETURN result;
END;

FUNCTION getRoles RETURN roleRecordCursor IS
	result roleRecordCursor;
BEGIN
	OPEN result FOR
		SELECT id, name FROM roles;
	RETURN result;
END;

END Accountfacade;
