package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent an association between an owning user type and a object and a hashmap-object.
 * 
 */
public class MapAssociation extends Association {
	
	/**
	 * When the association is a map, then the keyType is the type of the map-key, in every other circumstance null.
	 */
	private final Type keyType;
	
	/**
	 * Getter of the map-key type of the association.
	 * 
	 * @return Provides the map-key type of the association or null when no map-key type is set.
	 */
	public Type getKeyType() {
		return this.keyType;
	}
	
	/**
	 * Constructor for a new association. It should only be calles by the class facade or unit tests because the Ids are
	 * provided by the database.
	 * 
	 * @param id
	 *            The Id of the association in the database.
	 * @param name
	 *            The name of the UnidirectionalAssociation.
	 * @param owner
	 *            The Owner type of the association.
	 * @param target
	 *            The target type of the association.
	 * @param keyType
	 *            The hashmap-key type of the association.
	 * @param essential
	 *            true if map values can be empty
	 */
	public MapAssociation(final long id,
			final String name,
			final UserType owner,
			final Type target,
			final Type keyType,
			final boolean essential) {
		super(id, name, owner, target, essential, true);
		this.keyType = keyType;
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		if (other instanceof MapAssociation) {
			return super.isTheSameAs(other);
		}
		return false;
	}
}
