package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.PersistenceException;

/**
 * Defines the interface for user specified database initializing routines for Types and associations.
 * 
 */
public interface DatabaseInitializer {
	
	/**
	 * This method initializes a set of user defined types and associations.
	 * 
	 * @param facade
	 *            The ClassFacade which will be used during the initialization.
	 * @param typeManager
	 *            An implementation of a type Manager. It should be used to save user types and associations created in
	 *            this initializer.
	 * @throws PersistenceException
	 *             The Exception occurring during database communication issues.
	 */
	void initialize(ClassFacade facade, TypeManagerImplementation typeManager) throws PersistenceException;
	
}
