/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.utils;

import de.fhdw.wtf.persistence.utils.PropertiesReader;
import de.fhdw.wtf.persistence.utils.PropertiesReaderFile;
import de.fhdw.wtf.persistence.utils.PropertiesReaderRessource;
import java.util.HashMap;
import java.util.MissingResourceException;

public class PropertiesReaderFactory {
    private static PropertiesReaderFactory _instance = null;

    public static synchronized PropertiesReaderFactory getInstance() {
        if (_instance == null) {
            _instance = new PropertiesReaderFactory();
        }
        return _instance;
    }

    public PropertiesReader getPropertiesReaderFile(String file) {
        PropertiesReaderFile reader = new PropertiesReaderFile();
        reader.initialize(file);
        return reader;
    }

    public PropertiesReader getPropertiesReaderOracle() {
        PropertiesReader reader = new PropertiesReaderFile();
        try {
            reader.initialize("oracle.properties");
            return reader;
        }
        catch (MissingResourceException missingResourceException) {
            reader = new PropertiesReaderRessource();
            try {
                reader.initialize("oracle");
                return reader;
            }
            catch (MissingResourceException missingResourceException2) {
                reader = new PropertiesReader(){
                    private final HashMap<String, String> propValues = new HashMap();

                    @Override
                    public void initialize(String propFile) throws MissingResourceException {
                        this.propValues.put("sid", "XE");
                        this.propValues.put("schema", "meta");
                        this.propValues.put("username", "meta");
                        this.propValues.put("password", "meta");
                        this.propValues.put("hostname", "localhost");
                        this.propValues.put("port", "1521");
                    }

                    @Override
                    public String getProperty(String key) {
                        if (!this.propValues.containsKey(key)) {
                            return "";
                        }
                        return this.propValues.get(key);
                    }
                };
                reader.initialize("");
                return reader;
            }
        }
    }
}

