/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.BaseTypeNotFoundException;
import de.fhdw.wtf.persistence.exception.InvalidLinkException;
import de.fhdw.wtf.persistence.exception.NotInstantiatableException;
import de.fhdw.wtf.persistence.exception.ObjectNotFoundException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.ObjectFacade;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.facade.TypeManagerImplementation;
import de.fhdw.wtf.persistence.meta.AdhocTransaction;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.IntegerValue;
import de.fhdw.wtf.persistence.meta.Link;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.MapLink;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringValue;
import de.fhdw.wtf.persistence.meta.Transaction;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UnidirectionalLink;
import de.fhdw.wtf.persistence.meta.UserObject;
import de.fhdw.wtf.persistence.meta.UserType;
import de.fhdw.wtf.persistence.utils.Tuple;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class NoDatabaseObjectFacadeImplementation
implements ObjectFacade {
    private static final long INITIAL_NEXT_ID = 1L;
    private final ClassFacade classFacade;
    private long nextId;
    private final Map<Long, UserObject> idToUserObject;
    private final Map<UserType, Collection<UserObject>> userTypeMappingToUserObjects;
    private final Map<Long, BigInteger> integerValues;
    private final Map<BigInteger, Long> inverseIntegerValues;
    private final Map<Long, String> stringValues;
    private final Map<String, Long> inverseStringValues;
    private final Map<Object, Collection<Tuple<UnidirectionalLink, UserObject>>> targetMappingToUnidirectionalLinksWithOwners;
    private final Map<UserObject, Collection<Tuple<UnidirectionalLink, Object>>> ownerMappingToUnidirectionalLinksWithTargets;

    public NoDatabaseObjectFacadeImplementation(ClassFacade classFacade) {
        this.classFacade = classFacade;
        this.nextId = 1L;
        this.userTypeMappingToUserObjects = new HashMap<UserType, Collection<UserObject>>();
        this.integerValues = new HashMap<Long, BigInteger>();
        this.stringValues = new HashMap<Long, String>();
        this.inverseIntegerValues = new HashMap<BigInteger, Long>();
        this.inverseStringValues = new HashMap<String, Long>();
        this.idToUserObject = new HashMap<Long, UserObject>();
        this.targetMappingToUnidirectionalLinksWithOwners = new HashMap<Object, Collection<Tuple<UnidirectionalLink, UserObject>>>();
        this.ownerMappingToUnidirectionalLinksWithTargets = new HashMap<UserObject, Collection<Tuple<UnidirectionalLink, Object>>>();
    }

    @Override
    public void clear() throws PersistenceException {
        this.nextId = 1L;
        this.userTypeMappingToUserObjects.clear();
        this.integerValues.clear();
        this.stringValues.clear();
        this.inverseIntegerValues.clear();
        this.inverseStringValues.clear();
        this.idToUserObject.clear();
    }

    @Override
    public Collection<UserObject> find(Association association, String string, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<UserObject> find(Association association, BigInteger integer, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, Object>> get(UserObject owner, UnidirectionalAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Object> get(UserObject owner, MapAssociation association, String key, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Object> get(UserObject owner, MapAssociation association, BigInteger key, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Object> get(UserObject owner, MapAssociation association, UserObject key, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(UserObject target, UnidirectionalAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(UserObject target, MapAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(String target, MapAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(BigInteger target, MapAssociation association, Date date) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<UserObject> find(Association assoc, String str, Transaction trans) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<UserObject> find(Association association, BigInteger integer, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, Object>> get(UserObject owner, UnidirectionalAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject owner, MapAssociation association, String key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject owner, MapAssociation association, BigInteger key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<MapLink, Object>> get(UserObject owner, MapAssociation association, UserObject key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UnidirectionalLink, UserObject>> inverseGet(UserObject target, UnidirectionalAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(UserObject target, MapAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(String target, MapAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Tuple<UserObject, Object>> inverseGet(BigInteger target, MapAssociation association, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public boolean isInConflict(Transaction before, Transaction after) throws PersistenceException {
        return false;
    }

    @Override
    public boolean isOpenTransaction(Transaction transaction) throws PersistenceException {
        return true;
    }

    @Override
    public UserObject create(UserType type, Transaction transaction) throws PersistenceException {
        if (type.isAbs()) {
            throw new NotInstantiatableException(new SQLException());
        }
        UserObject result = UserObject.init(this.getAndIncrementNextId(), type);
        this.idToUserObject.put(result.getId(), result);
        this.mapUserTypeToEmptyListIfNotExists(type);
        this.userTypeMappingToUserObjects.get(type).add(result);
        return result;
    }

    @Override
    public void delete(UserObject object, Transaction transaction) throws PersistenceException {
        this.idToUserObject.remove(object.getId());
        this.userTypeMappingToUserObjects.get(object.getInstanceOf()).remove(object);
    }

    @Override
    public UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, UserObject target, Transaction transaction) throws PersistenceException {
        return this.set(owner, association, target);
    }

    @Override
    public UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, BigInteger target, Transaction transaction) throws PersistenceException {
        return this.set(owner, association, new IntegerValue(target));
    }

    @Override
    public UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, String target, Transaction transaction) throws PersistenceException {
        return this.set(owner, association, new StringValue(target));
    }

    private UnidirectionalLink set(UserObject owner, UnidirectionalAssociation association, Object target) throws PersistenceException {
        this.throwInvalidLinkExceptionIfWrongTypeForLink(owner, association, target);
        UnidirectionalLink result = new UnidirectionalLink(this.getAndIncrementNextId(), owner, target, association);
        if (!this.ownerMappingToUnidirectionalLinksWithTargets.containsKey(owner)) {
            LinkedList<Tuple<UnidirectionalLink, Object>> ownerLinks = new LinkedList<Tuple<UnidirectionalLink, Object>>();
            ownerLinks.add(new Tuple<UnidirectionalLink, Object>(result, target));
            this.ownerMappingToUnidirectionalLinksWithTargets.put(owner, ownerLinks);
        }
        if (!this.targetMappingToUnidirectionalLinksWithOwners.containsKey(target)) {
            LinkedList<Tuple<UnidirectionalLink, UserObject>> targetLinks = new LinkedList<Tuple<UnidirectionalLink, UserObject>>();
            targetLinks.add(new Tuple<UnidirectionalLink, UserObject>(result, owner));
            this.targetMappingToUnidirectionalLinksWithOwners.put(target, targetLinks);
        }
        return result;
    }

    private void throwInvalidLinkExceptionIfWrongTypeForLink(UserObject owner, UnidirectionalAssociation association, Object target) throws PersistenceException {
        if (!this.classFacade.isSuperClassTo(association.getTarget(), target.getInstanceOf()) || !this.classFacade.isSuperClassTo(association.getOwner(), owner.getInstanceOf())) {
            throw new InvalidLinkException(new SQLException());
        }
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, UserObject target, String key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, BigInteger target, String key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, String target, String key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, UserObject target, BigInteger key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, BigInteger target, BigInteger key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, String target, BigInteger key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, UserObject target, UserObject key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, BigInteger target, UserObject key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public MapLink put(UserObject owner, MapAssociation association, String target, UserObject key, Transaction transaction) throws PersistenceException {
        return null;
    }

    @Override
    public void unset(Link link, Transaction transaction) throws PersistenceException {
    }

    @Override
    public void commit(Transaction transaction) throws PersistenceException {
    }

    @Override
    public void rollback(Transaction transaction) throws PersistenceException {
    }

    @Override
    public void savePoint(Transaction transaction) throws PersistenceException {
    }

    @Override
    public void rollbackToSavePoint(Transaction transaction) throws PersistenceException {
    }

    @Override
    public BigInteger getIntForId(long id) throws PersistenceException {
        if (!this.integerValues.containsKey(id)) {
            throw new BaseTypeNotFoundException();
        }
        return this.integerValues.get(id);
    }

    @Override
    public String getStringForId(long id) throws PersistenceException {
        if (!this.stringValues.containsKey(id)) {
            throw new BaseTypeNotFoundException();
        }
        return this.stringValues.get(id);
    }

    @Override
    public long getIdForString(String string) throws PersistenceException {
        if (!this.inverseStringValues.containsKey(string)) {
            long newId = this.getAndIncrementNextId();
            this.stringValues.put(newId, string);
            this.inverseStringValues.put(string, newId);
        }
        return this.inverseStringValues.get(string);
    }

    @Override
    public long getIdForInteger(BigInteger integer) throws PersistenceException {
        if (!this.inverseIntegerValues.containsKey(integer)) {
            long newId = this.getAndIncrementNextId();
            this.integerValues.put(newId, integer);
            this.inverseIntegerValues.put(integer, newId);
        }
        return this.inverseIntegerValues.get(integer);
    }

    @Override
    public Transaction provideAdhocTransaction() throws PersistenceException {
        return new AdhocTransaction(this.getAndIncrementNextId());
    }

    @Override
    public TypeManager getTypeManager() {
        return TypeManagerImplementation.getInstance();
    }

    @Override
    public Collection<UserObject> findAllObjects(UserType type, Transaction transaction) throws PersistenceException {
        this.mapUserTypeToEmptyListIfNotExists(type);
        return this.userTypeMappingToUserObjects.get(type);
    }

    @Override
    public UserObject checkUserObjectOut(long id, Transaction transaction) throws PersistenceException {
        if (!this.idToUserObject.containsKey(id)) {
            throw new ObjectNotFoundException();
        }
        return this.idToUserObject.get(id);
    }

    private void mapUserTypeToEmptyListIfNotExists(UserType type) {
        if (!this.userTypeMappingToUserObjects.containsKey(type)) {
            this.userTypeMappingToUserObjects.put(type, new LinkedList());
        }
    }

    private long getAndIncrementNextId() {
        long result = this.nextId++;
        return result;
    }
}

