package de.fhdw.wtf.persistence.exception;

import java.sql.SQLException;

/**
 * This exception can be thrown if the attempt to create duplicate UserTypes occurs.
 */
public class DuplicateUserTypeException extends PersistenceException {
	/**
	 * the message of the exception.
	 */
	private static final String DUPLICATE_USER_TYPE_MESSAGE = "An UserType with the following name already exists: ";
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Returns an instance of DuplicateUserTypeException.
	 * 
	 * @param userTypeName
	 *            is needed to show an UserTypes name as part of the exception-message.
	 */
	public DuplicateUserTypeException(final String userTypeName) {
		super(DuplicateUserTypeException.DUPLICATE_USER_TYPE_MESSAGE + userTypeName, new SQLException());
	}
}
