package de.fhdw.wtf.persistence.exception;

/**
 * A class to represent an Exception, which occurs when the JDBC-Class-Facade and the PL/SQL-Class-Facade are not
 * consistent anymore and the JDBC facade expects types to be initialize, which are actually different to the types
 * instantiated by the PL/SQL-Facade.
 * 
 */
public class InitializingDatabaseContractViolationException extends PersistenceException {
	
	/**
	 * the message of the exception.
	 */
	private static final String CONTRACT_VIOLATION_MESSAGE =
			"The Contract for the initialization of the types between the JDBC-Facade and the PL/SQL-Facade has been violated: Please check the stored procedure classface.initialize and th OracleClassFacadeImplementation.java";
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Public constructor for an InitializingDatabaseContractViolationException.
	 */
	public InitializingDatabaseContractViolationException() {
		super(CONTRACT_VIOLATION_MESSAGE, null);
	}
	
	@Override
	public void printStackTrace() {
		System.err.println(CONTRACT_VIOLATION_MESSAGE + this.fillInStackTrace());
	}
	
}
