package de.fhdw.wtf.persistence.meta;

/**
 * A class to represent the Base Type String. A String is an arbitrary long sequence of characters. (Maximum: 4000 chars
 * 
 */
public final class StringType extends Type {
	
	/**
	 * The Name of the String Base Type.
	 */
	public static final String STRING_NAME = "String";
	
	/**
	 * The Id of String by Contract.
	 */
	public static final long String_ID = 1;
	
	/**
	 * A field to store the singleton instance of the String Base Type.
	 */
	private static StringType instance;
	
	/**
	 * Provides the only instance of the string base type. Realizes the singleton pattern.
	 * 
	 * @return Provides the String.
	 */
	public static synchronized StringType getInstance() {
		if (instance == null) {
			instance = new StringType(String_ID);
		}
		return instance;
	}
	
	/**
	 * Private constructor for a new String Type.
	 * 
	 * @param id
	 */
	private StringType(final long id) {
		super(id, STRING_NAME, false, false);
	}
	
	@Override
	public void accept(final TypeVisitor typeVisitor) {
		typeVisitor.handleBaseType(this);
		
	}
	
	@Override
	public <X> X accept(final TypeVisitorReturn<X> typeVisitor) {
		return typeVisitor.handleBaseType(this);
	}
	
	@Override
	public <Exc extends Exception> void accept(final TypeVisitorException<Exc> typeVisitor) throws Exc {
		typeVisitor.handleBaseType(this);
	}
	
	@Override
	public <X, Y extends Exception> X accept(final TypeVisitorReturnException<X, Y> typeVisitorReturnException)
			throws Y {
		return typeVisitorReturnException.handleBaseType(this);
	}
	
	@Override
	public boolean isTheSameAs(final java.lang.Object other) {
		return other instanceof StringType;
	}
	
}
