package de.fhdw.wtf.persistence.exception;

/**
 * 
 * A Class to represent an Exception, which occurs when someone tries to execute Database operations before connecting.
 */
public class NotConnectedException extends PersistenceException {
	
	/**
	 * the message of the exception.
	 */
	private static final String NOT_CONNECTED_MESSAGE = "The connection towards the Database was not established !!!";
	
	/**
	 * Constructor for a not Connected Exception.
	 */
	public NotConnectedException() {
		super("Es besteht keine Verbindung zur Datenbank", null);
	}
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@Override
	public void printStackTrace() {
		System.err.println(NOT_CONNECTED_MESSAGE + this.fillInStackTrace());
	}
	
}
