/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.ClassFacadeUninitializedException;
import de.fhdw.wtf.persistence.exception.FileDeleteIOException;
import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.exception.RuntimePersistenceException;
import de.fhdw.wtf.persistence.facade.ClassFacade;
import de.fhdw.wtf.persistence.facade.IDManager;
import de.fhdw.wtf.persistence.facade.OracleDatabaseManager;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import de.fhdw.wtf.persistence.meta.UserType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class AsynchronousAlteringOnExistingModellClassFacadeImplementation
implements ClassFacade {
    private ClassFacade instanceToDelegateNonAlteringCalls = null;
    public static final String SCRIPT_FILE_NAME = "modelChangesScript.sql";

    private void createScriptFileIfNotExists() throws IOException {
        File fileScript = new File(SCRIPT_FILE_NAME);
        if (!fileScript.exists()) {
            fileScript.createNewFile();
        }
    }

    public static void deleteScriptFileIfExists() throws IOException {
        File fileScript = new File(SCRIPT_FILE_NAME);
        if (fileScript.exists() && !fileScript.isDirectory() && !fileScript.delete()) {
            throw new FileDeleteIOException(fileScript);
        }
    }

    public AsynchronousAlteringOnExistingModellClassFacadeImplementation(ClassFacade instanceToDelegateNonAlteringCalls) {
        this.instanceToDelegateNonAlteringCalls = instanceToDelegateNonAlteringCalls;
    }

    @Override
    public UserType createUserType(String name, boolean abs, boolean transaction) throws PersistenceException {
        String theNewId = Long.toString(IDManager.instance().pullNextUnusedTypeID(name));
        String absInt = abs ? "1" : "0";
        String transInt = transaction ? "1" : "0";
        String createUserTypeCommand = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.createUserType(" + theNewId + "," + "'" + name + "'" + "," + absInt + "," + transInt + ");";
        try {
            this.createScriptFileIfNotExists();
        }
        catch (IOException e) {
            throw new RuntimePersistenceException(e);
        }
        try (PrintWriter scriptWriter = new PrintWriter(new BufferedWriter(new FileWriter(SCRIPT_FILE_NAME, true)));){
            scriptWriter.println(createUserTypeCommand);
            scriptWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new UserType(Long.parseLong(theNewId), name, abs, transaction);
    }

    @Override
    public UnidirectionalAssociation createUnidirectionalAssociation(String name, boolean essential, boolean unique, UserType owner, Type target) throws PersistenceException {
        String essentialInt = essential ? "1" : "0";
        String uniqueInt = unique ? "1" : "0";
        String theNewId = Long.toString(IDManager.instance().pullNextUnusedAssociationID(name));
        String createAssociationCommand = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.createAssociation(" + theNewId + "," + "'" + name + "'" + "," + Long.toString(owner.getId()) + "," + Long.toString(target.getId()) + "," + essentialInt + "," + uniqueInt + ");";
        try {
            this.createScriptFileIfNotExists();
        }
        catch (IOException e) {
            throw new RuntimePersistenceException(e);
        }
        try (PrintWriter scriptWriter = new PrintWriter(new BufferedWriter(new FileWriter(SCRIPT_FILE_NAME, true)));){
            scriptWriter.println(createAssociationCommand);
            scriptWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new UnidirectionalAssociation(Long.parseLong(theNewId), name, owner, target, essential, unique);
    }

    @Override
    public MapAssociation createMapAssociation(String name, boolean essential, UserType owner, Type target, Type keyType) throws PersistenceException {
        String essentialInt = essential ? "1" : "0";
        String uniqueInt = "1";
        String theNewId = Long.toString(IDManager.instance().pullNextUnusedAssociationID(name));
        String createAssociationThreeDigitCommand = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.createAssociation3(" + theNewId + "," + "'" + name + "'" + "," + Long.toString(owner.getId()) + "," + Long.toString(target.getId()) + "," + essentialInt + "," + "1" + "," + Long.toString(keyType.getId()) + ");";
        try {
            this.createScriptFileIfNotExists();
        }
        catch (IOException e) {
            throw new RuntimePersistenceException(e);
        }
        try (PrintWriter scriptWriter = new PrintWriter(new BufferedWriter(new FileWriter(SCRIPT_FILE_NAME, true)));){
            scriptWriter.println(createAssociationThreeDigitCommand);
            scriptWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new MapAssociation(Long.parseLong(theNewId), name, owner, target, keyType, essential);
    }

    @Override
    public void createSpecializationBetween(UserType ancestor, Type descendant) throws PersistenceException {
        String createSpecializationCommand = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.createSpecialization(" + Long.toString(ancestor.getId()) + "," + Long.toString(descendant.getId()) + ");";
        try {
            this.createScriptFileIfNotExists();
        }
        catch (IOException e) {
            throw new RuntimePersistenceException(e);
        }
        try (PrintWriter scriptWriter = new PrintWriter(new BufferedWriter(new FileWriter(SCRIPT_FILE_NAME, true)));){
            scriptWriter.println(createSpecializationCommand);
            scriptWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isSuperClassTo(Type ancestor, Type descendant) throws PersistenceException {
        return this.instanceToDelegateNonAlteringCalls.isSuperClassTo(ancestor, descendant);
    }

    @Override
    public void finalizeSpecialization() throws PersistenceException {
        String finalizeSpecializationCommand = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.finalizeSpecialization;";
        try {
            this.createScriptFileIfNotExists();
        }
        catch (IOException e) {
            throw new RuntimePersistenceException(e);
        }
        try (PrintWriter scriptWriter = new PrintWriter(new BufferedWriter(new FileWriter(SCRIPT_FILE_NAME, true)));){
            scriptWriter.println(finalizeSpecializationCommand);
            scriptWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clear() throws PersistenceException {
        this.instanceToDelegateNonAlteringCalls.clear();
    }

    @Override
    public void initialize() throws PersistenceException {
        this.instanceToDelegateNonAlteringCalls.clear();
    }

    @Override
    public void initializeForRuntime() throws PersistenceException {
        this.instanceToDelegateNonAlteringCalls.initializeForRuntime();
    }

    @Override
    public boolean hasBeenInitialized() {
        return this.instanceToDelegateNonAlteringCalls.hasBeenInitialized();
    }

    @Override
    public TypeManager getTypeManager() throws ClassFacadeUninitializedException {
        return this.instanceToDelegateNonAlteringCalls.getTypeManager();
    }

    @Override
    public void renameType(Long typeId, String newName) throws PersistenceException {
        String command = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.renameType(%s,%s);";
        command = String.format(command, typeId.toString(), newName);
        this.writeCommandToFile(command);
    }

    @Override
    public void renameAssociation(Long assoId, String newName) throws PersistenceException {
        String command = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.renameAssociation(%s,%s);";
        command = String.format(command, assoId.toString(), newName);
        this.writeCommandToFile(command);
    }

    @Override
    public void deleteAssociation(Long associationId) throws PersistenceException {
        String command = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.deleteAssociation(%s);";
        command = String.format(command, associationId.toString());
        this.writeCommandToFile(command);
    }

    @Override
    public void deleteUserType(Long typeId) throws PersistenceException {
        String command = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.deleteUserTypeAndSpec(%s);";
        command = String.format(command, typeId.toString());
        this.writeCommandToFile(command);
    }

    @Override
    public void updateLinksToNewAssociation(Long associationId, Collection<Long> newAssociationIds) throws PersistenceException {
        String command = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.pushDownLinks(%s,ARRAY_INT(%s));";
        command = String.format(command, associationId.toString(), this.createCSVFormat(newAssociationIds));
        this.writeCommandToFile(command);
    }

    @Override
    public void moveLinksAndCreateObjects(List<Long> oldAssoIds, Association newAsso, UserType newType, List<Long> newAssoIds) throws PersistenceException {
        String command = "execute " + OracleDatabaseManager.getInstance().getSchemaName() + ".classfacade.moveLinksAndCreateObjects(ARRAY_INT(%s),%s,%s,ARRAY_INT(%s));";
        command = String.format(command, this.createCSVFormat(oldAssoIds), Long.valueOf(newAsso.getId()).toString(), Long.valueOf(newType.getId()).toString(), this.createCSVFormat(newAssoIds));
        this.writeCommandToFile(command);
    }

    private String createCSVFormat(Collection<Long> newAssociationIds) {
        StringBuffer resultBuffer = new StringBuffer();
        Iterator<Long> i = newAssociationIds.iterator();
        if (i.hasNext()) {
            resultBuffer.append(i.next().toString());
        }
        while (i.hasNext()) {
            Long current = i.next();
            resultBuffer.append(",");
            resultBuffer.append(current.toString());
        }
        return resultBuffer.toString();
    }

    private void writeCommandToFile(String command) {
        try {
            this.createScriptFileIfNotExists();
        }
        catch (IOException e) {
            throw new RuntimePersistenceException(e);
        }
        try (PrintWriter scriptWriter = new PrintWriter(new BufferedWriter(new FileWriter(SCRIPT_FILE_NAME, true)));){
            scriptWriter.println(command);
            scriptWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

