package de.fhdw.wtf.persistence.exception;

import java.sql.SQLException;

/**
 * A class to represent an Exception, which occurs when the instantiation of a class fails, this is usually the case,
 * when the given User Type is abstract.
 * 
 */
public class NotInstantiatableException extends PersistenceException {
	
	/**
	 * Fehlernummer.
	 */
	public static final long ERRORCODE = 20004;
	/**
	 * the message of the exception.
	 */
	private static final String NOT_INSTANTIABLE_MESSAGE = "Could not instiantiate the class, maybe it is abstract";
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	/**
	 * Constructor for a new NotInstiableException.
	 * 
	 * @param exception
	 *            The nested Exception, usually an uncaught user defined PL/SQL Exception
	 */
	public NotInstantiatableException(final SQLException exception) {
		super(NOT_INSTANTIABLE_MESSAGE, exception);
	}
	
}
