CREATE OR REPLACE PACKAGE BODY InitRoutines IS

/* This function takes the name OF a table <tableName>, column IN the table <columnName>, data type for the column <dataType>
   AND checks if the table, column AND data type triple exists for the current user.
   Returns 1 if the table was found AND 0 if not.
*/
FUNCTION doesColumnExist(tableName VARCHAR2,columnName VARCHAR2, dataType VARCHAR2) RETURN NUMBER IS
	CURSOR columnCoursor IS 
		SELECT TABLE_NAME FROM USER_TAB_COLUMNS
			WHERE COLUMN_NAME LIKE UPPER(columnName) AND TABLE_NAME LIKE UPPER(tableName) AND DATA_TYPE LIKE UPPER(dataType);
	readTableRow columnCoursor%ROWTYPE;
	returnVAL NUMBER := 0;
BEGIN
	OPEN columnCoursor;
		FETCH columnCoursor INTO readTableRow;
			IF columnCoursor%NOTFOUND THEN
				returnVAL := 0;
			ELSE 
				returnVAL := 1;
			END IF;
	CLOSE columnCoursor;
	RETURN returnVAL;
END;

/* This function takes the name OF a Sequencer <sequName>
   AND checks if the Sequencer exists for the current user.
   Returns 1 if the sequencer was found AND 0 if not.
*/
FUNCTION doesSequencerExist(sequName VARCHAR2) RETURN NUMBER IS
	CURSOR seqCoursor IS
		SELECT SEQUENCE_NAME FROM USER_SEQUENCES
			WHERE SEQUENCE_NAME LIKE UPPER(sequName);
	readTableRow seqCoursor%ROWTYPE;
	returnVAL NUMBER := 0;
BEGIN
	OPEN seqCoursor;
		FETCH seqCoursor INTO readTableRow;
			IF seqCoursor%NOTFOUND THEN
				returnVAL := 0;
			ELSE 
				returnVAL := 1;
			END IF;
	CLOSE seqCoursor;
	RETURN returnVAL;
END;

/* This function takes the name OF a Procedure <procName>
   AND checks if the Procedure exists for the current user.
   Returns 1 if the Procedure was found AND 0 if not.
*/
FUNCTION doesPrcdrExist(procName VARCHAR2) RETURN NUMBER IS
	CURSOR prcdrCoursor IS
		SELECT PROCEDURE_NAME FROM USER_PROCEDURES
			WHERE PROCEDURE_NAME LIKE UPPER(procName);
	readTableRow prcdrCoursor%ROWTYPE;
	returnVAL NUMBER := 0;
BEGIN
	OPEN prcdrCoursor;
		FETCH prcdrCoursor INTO readTableRow;
			IF prcdrCoursor%NOTFOUND THEN
				returnVAL := 0;
			ELSE 
				returnVAL := 1;
			END IF;
	CLOSE prcdrCoursor;
	RETURN returnVAL;
END;

/* Returns 1 if the CONSTRAINT with the name <constraintName> exists. */
FUNCTION doesConstraintExist(constraintName VARCHAR2) RETURN NUMBER IS
	CURSOR constraintCoursor IS
		SELECT CONSTRAINT_NAME FROM USER_CONSTRAINTS
			WHERE CONSTRAINT_NAME LIKE UPPER(constraintName);
	readTableRow constraintCoursor%ROWTYPE;
	returnVAL NUMBER := 0;
BEGIN
	OPEN constraintCoursor;
		FETCH constraintCoursor INTO readTableRow;
			IF constraintCoursor%NOTFOUND THEN
				returnVAL := 0;
			ELSE 
				returnVAL := 1;
			END IF;
	CLOSE constraintCoursor;
	RETURN returnVAL;
END;

/* Returns 1 if all constraints FROM the table schema exist. */
FUNCTION doAllCoonstraintsExist RETURN NUMBER IS
BEGIN
	CASE 0 
		WHEN doesConstraintExist('ck_abstract_bool') THEN RETURN 0;
		WHEN doesConstraintExist('ck_trans_bool') THEN RETURN 0;
		WHEN doesConstraintExist('fk_owner') THEN RETURN 0;
		WHEN doesConstraintExist('fk_target') THEN RETURN 0;
		WHEN doesConstraintExist('ck_uniq_bool') THEN RETURN 0;
		WHEN doesConstraintExist('ck_essential_bool') THEN RETURN 0;
		WHEN doesConstraintExist('fk_ancestor') THEN RETURN 0;
		WHEN doesConstraintExist('fk_asso_id') THEN RETURN 0;
		WHEN doesConstraintExist('fk_descendant') THEN RETURN 0;
		WHEN doesConstraintExist('fk_map_key_type') THEN RETURN 0;
		WHEN doesConstraintExist('fk_io') THEN RETURN 0;
		WHEN doesConstraintExist('ck_is_adhoc_bool') THEN RETURN 0;
		WHEN doesConstraintExist('fk_container') THEN RETURN 0;
		WHEN doesConstraintExist('fk_next') THEN RETURN 0;
		WHEN doesConstraintExist('fk_created') THEN RETURN 0;
		WHEN doesConstraintExist('fk_owner_lnk') THEN RETURN 0;
		WHEN doesConstraintExist('fk_target_lnk') THEN RETURN 0;
		WHEN doesConstraintExist('fk_instance_of_lnk') THEN RETURN 0;
		WHEN doesConstraintExist('fk_created_lnk') THEN RETURN 0;
		WHEN doesConstraintExist('fk_map_key') THEN RETURN 0;
		WHEN doesConstraintExist('fk_t') THEN RETURN 0;
		WHEN doesConstraintExist('ck_type') THEN RETURN 0;
		WHEN doesConstraintExist('fk_role') THEN RETURN 0;
		WHEN doesConstraintExist('fk_account') THEN RETURN 0;
    ELSE RETURN 1;
	END CASE;
END;

/* This Operation returns 1 if all tables, columns AND data-types FROM the meta schema exist.
*/
FUNCTION doAllColumnsExist RETURN NUMBER IS
BEGIN
	CASE 0 
		WHEN doesColumnExist('TYPE','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('TYPE','name','varchar2') THEN RETURN 0;
		WHEN doesColumnExist('TYPE','abstract','number') THEN RETURN 0;
		WHEN doesColumnExist('TYPE','trans','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Association','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Association','name','varchar2') THEN RETURN 0;
		WHEN doesColumnExist('Association','owner','number') THEN RETURN 0;
		WHEN doesColumnExist('Association','target','number') THEN RETURN 0;
		WHEN doesColumnExist('Association','uniq','number') THEN RETURN 0;
		WHEN doesColumnExist('Association','essential','number') THEN RETURN 0;
		WHEN doesColumnExist('MapAssociation','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('MapAssociation','map_key_type','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Specialization','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Specialization','ancestor','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Specialization','descendant','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Object','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Object','instance_of','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Long_transaction','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Long_transaction','is_adhoc','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Long_transaction','published','Timestamp(6)') THEN RETURN 0;
		WHEN doesColumnExist('short_transaction','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('short_transaction','container','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('short_transaction','next','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Integer_Value','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Integer_Value','value','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('string_value','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('string_value','value','varchar2') THEN RETURN 0;
		WHEN doesColumnExist('user_object','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('user_object','created','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Link','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Link','owner','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Link','target','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Link','instance_of','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Link','created','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('MapLink','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('MapLink','map_key','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Accessed','ID','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Accessed','v','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Accessed','t','NUMBER') THEN RETURN 0;
		WHEN doesColumnExist('Accessed','type','CHAR') THEN RETURN 0;
    ELSE RETURN 1;
	END CASE;
END;

/* This function returns 1 if all expected sequencers exist.
   If you have a new sequencer add the validity check IN this function.
*/
FUNCTION doAllSequencersExist RETURN NUMBER IS
BEGIN
	CASE 0 
		WHEN doesSequencerExist('Specialization_Seq') THEN RETURN 0;
		WHEN doesSequencerExist('InstanceItem_Seq') THEN RETURN 0;
		WHEN doesSequencerExist('short_transaction_seq') THEN RETURN 0;
		WHEN doesSequencerExist('Accessed_seq') THEN RETURN 0;
    ELSE RETURN 1;
	END CASE;
END;

/* This function returns 1 if all expected procedures exist.
   If you have a new procedure IN your set OF non init procedures add the validity check IN this function.
*/
FUNCTION doAllPrcdrsExist RETURN NUMBER IS
BEGIN
	CASE 0
		WHEN doesPrcdrExist('createUserType') THEN RETURN 0;
		WHEN doesPrcdrExist('createUnidirAssociation') THEN RETURN 0;
		WHEN doesPrcdrExist('createAssociation') THEN RETURN 0;
		WHEN doesPrcdrExist('createMapAssociation') THEN RETURN 0;
		WHEN doesPrcdrExist('createSpecialization') THEN RETURN 0;
		WHEN doesPrcdrExist('finalizeSpecialization') THEN RETURN 0;
		WHEN doesPrcdrExist('initialize') THEN RETURN 0;
		WHEN doesPrcdrExist('clearAll') THEN RETURN 0;
		WHEN doesPrcdrExist('clearSpecialization') THEN RETURN 0;
		WHEN doesPrcdrExist('doesTypeExist') THEN RETURN 0;
		WHEN doesPrcdrExist('doesAssociationExist') THEN RETURN 0;
		WHEN doesPrcdrExist('getMaxIdFromType') THEN RETURN 0;
		WHEN doesPrcdrExist('getMaxIdFromAssociation') THEN RETURN 0;
		WHEN doesPrcdrExist('isSuperclassTo') THEN RETURN 0;
		WHEN doesPrcdrExist('getAllTypes') THEN RETURN 0;
		WHEN doesPrcdrExist('getAllUnidirAssociations') THEN RETURN 0;
		WHEN doesPrcdrExist('getAllMapAssociations') THEN RETURN 0;
		WHEN doesPrcdrExist('getAllUnidirAssoWithFullName') THEN RETURN 0;
		WHEN doesPrcdrExist('getAllMapAssoWithFullName') THEN RETURN 0;

		WHEN doesPrcdrExist('findString') THEN RETURN 0;
		WHEN doesPrcdrExist('findInteger') THEN RETURN 0;
		WHEN doesPrcdrExist('get') THEN RETURN 0;
		WHEN doesPrcdrExist('getMapUO') THEN RETURN 0;
		WHEN doesPrcdrExist('getMapStr') THEN RETURN 0;
		WHEN doesPrcdrExist('getMapInt') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGet') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetMapUO') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetMapStr') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetMapInt') THEN RETURN 0;
		WHEN doesPrcdrExist('findStringTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('findIntegerTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('getTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('getTransactionCursor') THEN RETURN 0;
		WHEN doesPrcdrExist('getMapUOTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('getMapStrTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('getMapIntTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetTransactionCursor') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetMapUOTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetMapStrTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('inverseGetMapIntTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('getActiveShortTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('insertReadAccessed') THEN RETURN 0;
		WHEN doesPrcdrExist('insertModifiedAccessed') THEN RETURN 0;
		WHEN doesPrcdrExist('insertDeletedAccessed') THEN RETURN 0;
		WHEN doesPrcdrExist('setUO') THEN RETURN 0;
		WHEN doesPrcdrExist('setStr') THEN RETURN 0;
		WHEN doesPrcdrExist('setInt') THEN RETURN 0;
		WHEN doesPrcdrExist('putUOUO') THEN RETURN 0;
		WHEN doesPrcdrExist('putUOStr') THEN RETURN 0;
		WHEN doesPrcdrExist('putUOInt') THEN RETURN 0;
		WHEN doesPrcdrExist('putStrUO') THEN RETURN 0;
		WHEN doesPrcdrExist('putStrStr') THEN RETURN 0;
		WHEN doesPrcdrExist('putStrInt') THEN RETURN 0;
		WHEN doesPrcdrExist('putIntUO') THEN RETURN 0;
		WHEN doesPrcdrExist('putIntStr') THEN RETURN 0;
		WHEN doesPrcdrExist('putIntInt') THEN RETURN 0;
		WHEN doesPrcdrExist('unset') THEN RETURN 0;
		WHEN doesPrcdrExist('createUserObject') THEN RETURN 0;
		WHEN doesPrcdrExist('deleteUserObject') THEN RETURN 0;
		WHEN doesPrcdrExist('isTransactionOpen') THEN RETURN 0;
		WHEN doesPrcdrExist('getConflictingTransactions') THEN RETURN 0;
		WHEN doesPrcdrExist('rollbackTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('commitTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('makeSavePoint') THEN RETURN 0;
		WHEN doesPrcdrExist('rollbackToSavePoint') THEN RETURN 0;
		WHEN doesPrcdrExist('rightDateGreaterEqualsLeftDate') THEN RETURN 0;
		WHEN doesPrcdrExist('getString') THEN RETURN 0;
		WHEN doesPrcdrExist('getInteger') THEN RETURN 0;
		WHEN doesPrcdrExist('getStringObject') THEN RETURN 0;
		WHEN doesPrcdrExist('getIntegerObject') THEN RETURN 0;
		WHEN doesPrcdrExist('provideAdhocTransaction') THEN RETURN 0;
		WHEN doesPrcdrExist('getLinkCountOfAssoForOwner') THEN RETURN 0;
    ELSE RETURN 1;
	END CASE;
END;

/* Returns 1 the current table schema IS valid. */
FUNCTION isValidTableStructureCreated RETURN NUMBER IS
BEGIN
  IF doAllColumnsExist=1 AND doAllSequencersExist=1 AND doAllCoonstraintsExist=1 THEN
    RETURN 1;
  ELSE
    RETURN 0;
  END IF;
END;

/* Returns 1 if all expected procedures AND functions FROM the class- AND objectfacade exist. */
FUNCTION areProceduresCreated RETURN NUMBER IS
BEGIN
  IF doAllPrcdrsExist=1 THEN
    RETURN 1;
  ELSE
    RETURN 0;
  END IF;
END;

END InitRoutines;
