package de.fhdw.wtf.persistence.facade;

import java.util.Set;

import de.fhdw.wtf.persistence.exception.PersistenceException;
import de.fhdw.wtf.persistence.meta.Mandant;
import de.fhdw.wtf.persistence.meta.Role;
import de.fhdw.wtf.persistence.meta.User;

public interface AuthorizationFacade {
	
	Mandant createMandant(String id, String rootPassword) throws PersistenceException;
	
	void logIn(Mandant mandant) throws PersistenceException;
	
	boolean isPasswordCorrect(String mandant, String username, String password) throws PersistenceException;
	
	User createUser(String username, String password) throws PersistenceException;
	
	void grantRoleToUser(User user, Role role) throws PersistenceException;
	
	Role createRole(String name) throws PersistenceException;
	
	Set<Role> getRolesFrom(User user) throws PersistenceException;
	
	Set<User> getUsers() throws PersistenceException;
	
	User getUser(String mandant, String name) throws PersistenceException;
	
	Set<Role> listAllRoles() throws PersistenceException;
	
}
