package de.fhdw.wtf.persistence.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;

/**
 * This PropertiesReader tries to read properties from a file in a given directory. The content of the file should be
 * seperated by "key1=value1".
 * 
 * @author HFW413hy
 *
 */
public class PropertiesReaderFile implements PropertiesReader {
	
	/**
	 * Stores the internal key-value-pairs.
	 */
	private final HashMap<String, String> propValues = new HashMap<>();
	
	@Override
	public String getProperty(final String key) {
		if (!this.propValues.containsKey(key)) {
			return "";
		}
		return this.propValues.get(key);
	}
	
	@Override
	public void initialize(final String propFile) throws MissingResourceException {
		final File f = new File(propFile);
		if (!f.exists()) {
			throw new MissingResourceException("", "", "");
		}
		
		final Properties props = new Properties();
		try (final FileInputStream inputStream = new FileInputStream(new File(propFile))) {
			props.load(inputStream);
		} catch (final IOException e) {
			throw new MissingResourceException("", "", "");
		}
		
		final Enumeration<Object> keys = props.keys();
		while (keys.hasMoreElements()) {
			final String key = (String) keys.nextElement();
			final String value = props.getProperty(key);
			this.propValues.put(key, value);
		}
	}
}
