/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.utils;

import de.fhdw.wtf.persistence.utils.PropertiesReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;

public class PropertiesReaderFile
implements PropertiesReader {
    private final HashMap<String, String> propValues = new HashMap();

    @Override
    public String getProperty(String key) {
        if (!this.propValues.containsKey(key)) {
            return "";
        }
        return this.propValues.get(key);
    }

    @Override
    public void initialize(String propFile) throws MissingResourceException {
        File f = new File(propFile);
        if (!f.exists()) {
            throw new MissingResourceException("", "", "");
        }
        Properties props = new Properties();
        try (FileInputStream inputStream = new FileInputStream(new File(propFile));){
            props.load(inputStream);
        }
        catch (IOException e) {
            throw new MissingResourceException("", "", "");
        }
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = props.getProperty(key);
            this.propValues.put(key, value);
        }
    }
}

