/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.wtf.persistence.facade;

import de.fhdw.wtf.persistence.exception.TypeOrAssociationNotFoundException;
import de.fhdw.wtf.persistence.facade.TypeManager;
import de.fhdw.wtf.persistence.meta.Association;
import de.fhdw.wtf.persistence.meta.MapAssociation;
import de.fhdw.wtf.persistence.meta.Specialization;
import de.fhdw.wtf.persistence.meta.Type;
import de.fhdw.wtf.persistence.meta.UnidirectionalAssociation;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class TypeManagerImplementation
implements TypeManager {
    private static final String JAVA_PACKAGE_SEPERATOR = ".";
    private final Map<Long, Type> cacheId = new HashMap<Long, Type>();
    private final Map<Long, Association> associationCacheId = new HashMap<Long, Association>();
    private final Map<String, Type> cacheName = new HashMap<String, Type>();
    private final Map<String, Association> cacheAssociationName = new HashMap<String, Association>();
    private final Collection<Specialization> specializations = new LinkedList<Specialization>();

    public static TypeManagerImplementation getInstance() {
        return new TypeManagerImplementation();
    }

    private TypeManagerImplementation() {
    }

    private String prepareName(String name) {
        return name.replace('>', '.').replace('$', '.');
    }

    @Override
    public Type getTypeForId(long id) throws TypeOrAssociationNotFoundException {
        if (!this.cacheId.containsKey(id)) {
            throw new TypeOrAssociationNotFoundException(id);
        }
        return this.cacheId.get(id);
    }

    @Override
    public Type getTypeforName(String name) throws TypeOrAssociationNotFoundException {
        if (!this.cacheName.containsKey(this.prepareName(name))) {
            throw new TypeOrAssociationNotFoundException(name);
        }
        return this.cacheName.get(this.prepareName(name));
    }

    @Override
    public UnidirectionalAssociation getUnidirectionalAssociationForId(long id) throws TypeOrAssociationNotFoundException {
        if (!this.associationCacheId.containsKey(id)) {
            throw new TypeOrAssociationNotFoundException(id);
        }
        Association association = this.associationCacheId.get(id);
        if (!(association instanceof UnidirectionalAssociation)) {
            throw new TypeOrAssociationNotFoundException(id);
        }
        return (UnidirectionalAssociation)association;
    }

    @Override
    public MapAssociation getMapAssociationForId(long id) throws TypeOrAssociationNotFoundException {
        if (!this.associationCacheId.containsKey(id)) {
            throw new TypeOrAssociationNotFoundException(id);
        }
        Association association = this.associationCacheId.get(id);
        if (!(association instanceof MapAssociation)) {
            throw new TypeOrAssociationNotFoundException(id);
        }
        return (MapAssociation)association;
    }

    @Override
    public UnidirectionalAssociation getUnidirectionalAssociationForName(String name) throws TypeOrAssociationNotFoundException {
        if (!this.cacheAssociationName.containsKey(this.prepareName(name))) {
            throw new TypeOrAssociationNotFoundException(name);
        }
        Association association = this.cacheAssociationName.get(this.prepareName(name));
        if (!(association instanceof UnidirectionalAssociation)) {
            throw new TypeOrAssociationNotFoundException(name);
        }
        return (UnidirectionalAssociation)association;
    }

    @Override
    public MapAssociation getMapAssociationForName(String name) throws TypeOrAssociationNotFoundException {
        if (!this.cacheAssociationName.containsKey(this.prepareName(name))) {
            throw new TypeOrAssociationNotFoundException(name);
        }
        Association association = this.cacheAssociationName.get(this.prepareName(name));
        if (!(association instanceof MapAssociation)) {
            throw new TypeOrAssociationNotFoundException(name);
        }
        return (MapAssociation)association;
    }

    @Override
    public void saveType(Type type) {
        this.cacheId.put(type.getId(), type);
        String name = this.prepareName(type.getName());
        this.cacheName.put(name, type);
    }

    @Override
    public void saveAssociation(Association association) {
        this.associationCacheId.put(association.getId(), association);
        String name = this.prepareName(association.getOwner().getName()) + JAVA_PACKAGE_SEPERATOR + this.prepareName(association.getName());
        this.cacheAssociationName.put(name, association);
    }

    @Override
    public long getMaximumTypeId() {
        long result = 0L;
        for (Type type : this.cacheId.values()) {
            if (type.getId() <= result) continue;
            result = type.getId();
        }
        return result;
    }

    @Override
    public void clear() {
        this.cacheId.clear();
        this.cacheName.clear();
        this.associationCacheId.clear();
        this.cacheAssociationName.clear();
        this.specializations.clear();
    }

    @Override
    public void deleteType(long typeId) throws TypeOrAssociationNotFoundException {
        if (!this.cacheId.containsKey(typeId)) {
            throw new TypeOrAssociationNotFoundException(typeId);
        }
        this.cacheName.remove(this.prepareName(this.cacheId.remove(typeId).getName()));
    }

    @Override
    public void deleteAssociation(long associationId) throws TypeOrAssociationNotFoundException {
        if (!this.associationCacheId.containsKey(associationId)) {
            throw new TypeOrAssociationNotFoundException(associationId);
        }
        this.cacheAssociationName.remove(this.associationCacheId.remove(associationId));
    }

    @Override
    public void saveSpecialization(Specialization specialization) {
        this.specializations.add(specialization);
    }

    @Override
    public Collection<Specialization> getAllSpecializations() {
        return new LinkedList<Specialization>(this.specializations);
    }

    @Override
    public void deleteSpecialization(Specialization specialization) {
        this.specializations.remove(specialization);
    }

    @Override
    public boolean existsType(long typeId) {
        return this.cacheId.containsKey(typeId);
    }

    @Override
    public boolean existsType(String typeName) {
        return this.cacheName.containsKey(this.prepareName(typeName));
    }

    @Override
    public boolean existsAssociation(long associationId) {
        return this.associationCacheId.containsKey(associationId);
    }

    @Override
    public boolean existsSpecialization(long specializationId) {
        return false;
    }
}

