CREATE OR REPLACE PACKAGE ClassFacade IS

/* constants used for initialization */
string_id constant NUMBER := 1;
integer_id constant NUMBER := 2;

TYPE classInfo IS RECORD(
	id NUMBER,
	name VARCHAR2(4000),
	abstract NUMBER(1),
	trans NUMBER(1)
);
TYPE classInfoCursor IS REF CURSOR RETURN classInfo;

TYPE UnidirAssociationInfo IS RECORD(
	id NUMBER,
	name VARCHAR2(4000),
	owner NUMBER,
	target NUMBER,
	essential NUMBER,
	uniq NUMBER
);
TYPE UnidirAssociationInfoCursor IS REF CURSOR RETURN UnidirAssociationInfo;

TYPE MapAssociationInfo IS RECORD(
	id NUMBER,
	name VARCHAR2(4000),
	owner NUMBER,
	target NUMBER,
	keyid NUMBER,
	essential NUMBER
);
TYPE MapAssociationInfoCursor IS REF CURSOR RETURN MapAssociationInfo;

PROCEDURE createUserType(id NUMBER, name VARCHAR2, abstract NUMBER, trans NUMBER);
PROCEDURE createSpecialization(ancestor NUMBER, descendant NUMBER);
PROCEDURE createUnidirAssociation(id NUMBER, name VARCHAR2, owner NUMBER, target NUMBER, essential NUMBER, uniq NUMBER);
PROCEDURE createAssociation(id NUMBER, name VARCHAR2, owner NUMBER, target NUMBER, essential NUMBER, uniq NUMBER);
PROCEDURE createMapAssociation(id NUMBER, name VARCHAR2, owner NUMBER, target NUMBER, essential NUMBER, uniq NUMBER, map_key_type NUMBER);
PROCEDURE finalizeSpecialization;
PROCEDURE initialize;
PROCEDURE clearAll;
PROCEDURE clearSpecialization;
FUNCTION doesTypeExist(name VARCHAR2) RETURN NUMBER;
FUNCTION doesAssociationExist(name VARCHAR2) RETURN NUMBER;
FUNCTION getMaxIdFromType RETURN NUMBER;
FUNCTION getMaxIdFromAssociation RETURN NUMBER;
FUNCTION isSuperclassTo(a NUMBER, d NUMBER) RETURN NUMBER;
FUNCTION getAllTypes RETURN classInfoCursor;
FUNCTION getAllUnidirAssociations RETURN UnidirAssociationInfoCursor;
FUNCTION getAllMapAssociations RETURN MapAssociationInfoCursor;
FUNCTION getAllUnidirAssoWithFullName RETURN UnidirAssociationInfoCursor;
FUNCTION getAllMapAssoWithFullName RETURN MapAssociationInfoCursor;
PROCEDURE renameType(typeId NUMBER, newName VARCHAR2);
PROCEDURE renameAssociation(assoId NUMBER, newName VARCHAR2);
PROCEDURE pushDownLinks(oldAssociation NUMBER, newAssociations array_int);
PROCEDURE deleteAssociation(oldAssociation NUMBER);
PROCEDURE deleteUserTypeAndSpec(typeId NUMBER);

END ClassFacade;

