package de.fhdw.wtf.persistence.meta;

/**
 * object of a point-to-point association.
 */
public class UnidirectionalLink extends Link {
	
	/**
	 * The type of this link.
	 */
	private final UnidirectionalAssociation instanceOf;
	
	@Override
	public UnidirectionalAssociation getInstanceOf() {
		return this.instanceOf;
	}
	
	/**
	 * creates a unidirectional link between two objects.
	 * 
	 * @param id
	 *            the id of the link
	 * @param owner
	 *            the owner of the link
	 * @param target
	 *            the target of the link
	 * @param instanceOf
	 *            the unidirectional association of the link
	 */
	public UnidirectionalLink(final long id,
			final UserObject owner,
			final Object target,
			final UnidirectionalAssociation instanceOf) {
		super(id, owner, target);
		this.instanceOf = instanceOf;
	}
	
	@Override
	public boolean equals(final java.lang.Object other) {
		if (!(other instanceof UnidirectionalLink)) {
			return false;
		}
		
		final UnidirectionalLink unidirectionalLink = (UnidirectionalLink) other;
		return super.equals(unidirectionalLink) && this.getInstanceOf().equals(unidirectionalLink.getInstanceOf());
	}
	
	@Override
	public int hashCode() {
		return super.hashCode() ^ this.instanceOf.hashCode();
	}
}
