package de.fhdw.wtf.persistence.utils;

import java.sql.CallableStatement;
import java.sql.SQLException;

import de.fhdw.wtf.persistence.exception.NotValidInputException;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.StringValue;

/**
 * Wrapper for a String for a Database-Query.
 */
public class DBConnectionStringHandler implements DBConnectionObjectHandler {
	
	private final String string;
	
	@Override
	public String getObjectTypeString() {
		return "Str";
	}
	
	@Override
	public void handleCall(final CallableStatement call, final int parameterIndex) throws SQLException {
		call.setString(parameterIndex, this.string);
	}
	
	@Override
	public Object getObject() {
		return new StringValue(this.string);
	}
	
	/**
	 * creates a wrapper for a string for a database connection.
	 * 
	 * @param string
	 *            the wrapped string
	 * @throws NotValidInputException
	 *             throws when the given string is null
	 */
	public DBConnectionStringHandler(final String string) throws NotValidInputException {
		super();
		
		if (string == null) {
			throw new NotValidInputException("string");
		}
		
		this.string = string;
	}
}
