package de.fhdw.wtf.persistence.utils;

import java.sql.CallableStatement;
import java.sql.SQLException;

import de.fhdw.wtf.persistence.exception.NotValidInputException;
import de.fhdw.wtf.persistence.meta.Object;
import de.fhdw.wtf.persistence.meta.UserObject;

/**
 * Wrapper for a UserObject for a Database-Query.
 */
public class DBConnectionUserObjectHandler implements DBConnectionObjectHandler {
	
	private final UserObject userObject;
	
	@Override
	public String getObjectTypeString() {
		return "UO";
	}
	
	@Override
	public void handleCall(final CallableStatement call, final int parameterIndex) throws SQLException {
		call.setLong(parameterIndex, this.userObject.getId());
	}
	
	@Override
	public Object getObject() {
		return this.userObject;
	}
	
	/**
	 * creates a wrapper for a user object for a database connection.
	 * 
	 * @param userObject
	 *            the wrapped user object
	 * @throws NotValidInputException
	 *             throws when the given string is null
	 */
	public DBConnectionUserObjectHandler(final UserObject userObject) throws NotValidInputException {
		super();
		
		if (userObject == null) {
			throw new NotValidInputException("userObject");
		}
		
		this.userObject = userObject;
	}
}
