/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest.util;

import de.fhdw.gaming.contest.util.CombinatoricsHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

final class PermutationSplitIterator<T>
implements Spliterator<List<T>> {
    private final List<T> permutation;
    private final Comparator<T> comparator;
    private final long upperLimitOfNumberOfPermutations;

    PermutationSplitIterator(List<T> input, Comparator<T> comparator) {
        this.permutation = new ArrayList<T>(input);
        this.comparator = comparator;
        this.upperLimitOfNumberOfPermutations = CombinatoricsHelper.factorial(input.size());
        this.permutation.sort(comparator);
    }

    static <T extends Comparable<T>> PermutationSplitIterator<T> create(List<T> input) {
        return new PermutationSplitIterator<T>(input, Comparable::compareTo);
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        action.accept(new ArrayList<T>(this.permutation));
        return this.computeNextPermutation();
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.upperLimitOfNumberOfPermutations;
    }

    @Override
    public int characteristics() {
        return 337;
    }

    private boolean computeNextPermutation() {
        Integer left = this.getIndexOfLastItemBeingSmallerThanRightNeighbour();
        if (left == null) {
            return false;
        }
        Integer right = this.getIndexOfCeilingOfItem(this.permutation.get(left), left + 1);
        assert (right != null);
        Collections.swap(this.permutation, (int)left, (int)right);
        this.permutation.subList(left + 1, this.permutation.size()).sort(this.comparator);
        return true;
    }

    private Integer getIndexOfLastItemBeingSmallerThanRightNeighbour() {
        for (int index = this.permutation.size() - 2; index >= 0; --index) {
            if (this.comparator.compare(this.permutation.get(index), this.permutation.get(index + 1)) >= 0) continue;
            return index;
        }
        return null;
    }

    private Integer getIndexOfCeilingOfItem(T left, int startIndex) {
        Integer result = null;
        for (int index = startIndex; index < this.permutation.size(); ++index) {
            T right = this.permutation.get(index);
            if (this.comparator.compare(left, right) >= 0 || result != null && this.comparator.compare(right, this.permutation.get(result)) >= 0) continue;
            result = index;
        }
        return result;
    }
}

