/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Observer;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.core.domain.util.EventListCreator;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Optional;
import java.util.Set;

public final class RecordingObserver
implements Observer,
AutoCloseable {
    private final File gameEventFile;
    private final EventListCreator eventListCreator;
    private String finalState;

    public RecordingObserver(File gameEventFile) {
        this.gameEventFile = gameEventFile;
        this.eventListCreator = new EventListCreator();
    }

    public void started(Game<?, ?, ?, ?> game, State<?, ?> state) {
        this.eventListCreator.started(state);
    }

    public void nextPlayersComputed(Game<?, ?, ?, ?> game, State<?, ?> state, Set<? extends Player<?>> players) {
        this.eventListCreator.nextPlayersComputed(state, players);
    }

    public void illegalPlayerRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player) {
        this.eventListCreator.illegalPlayerRejected(state, player);
    }

    public void legalMoveApplied(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Move<?, ?> move) {
        this.eventListCreator.legalMoveApplied(state, player, move);
    }

    public void illegalMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Optional<Move<?, ?>> move, String reason) {
        this.eventListCreator.illegalMoveRejected(state, player, move, reason);
    }

    public void overdueMoveRejected(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player, Optional<Move<?, ?>> chosenMove) {
        this.eventListCreator.overdueMoveRejected(state, player, chosenMove);
    }

    public void playerResigned(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> player) {
        this.eventListCreator.playerResigned(state, player);
    }

    public void playerOvertaken(Game<?, ?, ?, ?> game, State<?, ?> state, Player<?> overtakenPlayer, Player<?> overtakingPlayer) {
        this.eventListCreator.playerOvertaken(state, overtakenPlayer, overtakingPlayer);
    }

    public void finished(Game<?, ?, ?, ?> game, State<?, ?> state) {
        this.eventListCreator.finished(state);
        this.finalState = "FINAL GAME STATE\n================\n" + state.toString() + "\n";
    }

    @Override
    public void close() throws IOException {
        try (PrintStream out = new PrintStream(this.gameEventFile);){
            out.println(this.eventListCreator.getResult());
            if (this.finalState != null) {
                out.println(this.finalState);
            }
        }
    }
}

