/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.gui;

import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.BooleanFieldType;
import de.fhdw.gaming.core.ui.type.FieldType;
import de.fhdw.gaming.core.ui.type.FieldTypeException;
import de.fhdw.gaming.core.ui.type.FieldTypeVisitor;
import de.fhdw.gaming.core.ui.type.FieldTypeWithValidator;
import de.fhdw.gaming.core.ui.type.IntegerFieldType;
import de.fhdw.gaming.core.ui.type.ObjectFieldType;
import de.fhdw.gaming.core.ui.type.StringFieldType;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.value.WritableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

final class ControlCreator
implements FieldTypeVisitor {
    private final String id;
    private final Consumer<? super String> validationHandler;
    private final Optional<Object> providedValue;
    private final Map<String, WritableObjectValue<Object>> values;
    private Region result;
    private Node focusTarget;
    private FieldType<?> originalFieldType;

    ControlCreator(String id, Consumer<? super String> validationHandler, Optional<Object> providedValue, Map<String, WritableObjectValue<Object>> values) {
        this.id = id;
        this.validationHandler = validationHandler;
        this.providedValue = providedValue;
        this.values = values;
    }

    Region getResult() {
        return this.result;
    }

    Node getFocusTarget() {
        return this.focusTarget;
    }

    public void handle(StringFieldType fieldType) {
        if (this.originalFieldType == null) {
            this.originalFieldType = fieldType;
        }
        TextField textField = new TextField();
        if (this.providedValue.isPresent()) {
            String fixedValue = (String)this.providedValue.get();
            this.values.get(this.id).set((Object)fixedValue);
            textField.setText(fixedValue);
            textField.setDisable(true);
        } else {
            fieldType.getDefaultValue().ifPresentOrElse(value -> {
                textField.setText(value);
                this.setFieldValue((String)value);
            }, () -> {
                textField.setText("");
                this.setFieldValue("");
            });
            textField.textProperty().addListener((observable, oldValue, newValue) -> this.setFieldValue((String)newValue));
            this.originalFieldType.getInfo().ifPresent(info -> textField.setTooltip(new Tooltip(info)));
        }
        this.result = textField;
        this.focusTarget = textField;
    }

    public void handle(IntegerFieldType fieldType) {
        if (this.originalFieldType == null) {
            this.originalFieldType = fieldType;
        }
        TextField textField = new TextField();
        if (this.providedValue.isPresent()) {
            String fixedValue = (String)this.providedValue.get();
            this.values.get(this.id).set((Object)fixedValue);
            textField.setText(fixedValue);
            textField.setDisable(true);
        } else {
            fieldType.getDefaultValue().ifPresentOrElse(value -> {
                textField.setText(value.toString());
                this.setFieldValue(value.toString());
            }, () -> {
                textField.setText("");
                this.setFieldValue("");
            });
            textField.textProperty().addListener((observable, oldValue, newValue) -> this.setFieldValue((String)newValue));
            this.originalFieldType.getInfo().ifPresent(info -> textField.setTooltip(new Tooltip(info)));
        }
        this.result = textField;
        this.focusTarget = textField;
    }

    public void handle(BooleanFieldType fieldType) {
        if (this.originalFieldType == null) {
            this.originalFieldType = fieldType;
        }
        ToggleGroup toggleGroup = new ToggleGroup();
        RadioButton yesButton = new RadioButton("yes");
        yesButton.setToggleGroup(toggleGroup);
        RadioButton noButton = new RadioButton("no");
        noButton.setToggleGroup(toggleGroup);
        if (this.providedValue.isPresent()) {
            boolean fixedValue = (Boolean)this.providedValue.get();
            if (fixedValue) {
                yesButton.setSelected(true);
                this.focusTarget = yesButton;
            } else {
                noButton.setSelected(true);
                this.focusTarget = noButton;
            }
            this.values.get(this.id).set((Object)fixedValue);
            yesButton.setDisable(true);
            noButton.setDisable(true);
        } else {
            fieldType.getDefaultValue().ifPresentOrElse(value -> {
                if (value.booleanValue()) {
                    yesButton.setSelected(true);
                    this.setFieldValue("true");
                    this.focusTarget = yesButton;
                } else {
                    noButton.setSelected(true);
                    this.setFieldValue("false");
                    this.focusTarget = noButton;
                }
            }, () -> {
                this.setFieldValue("");
                this.focusTarget = yesButton;
            });
            yesButton.selectedProperty().addListener((observable, oldValue, newValue) -> this.setFieldValue("true"));
            noButton.selectedProperty().addListener((observable, oldValue, newValue) -> this.setFieldValue("false"));
        }
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{yesButton, noButton});
        this.originalFieldType.getInfo().ifPresent(info -> {
            yesButton.setTooltip(new Tooltip(info));
            noButton.setTooltip(new Tooltip(info));
        });
        this.result = hBox;
    }

    public void handle(ObjectFieldType fieldType) {
        if (this.originalFieldType == null) {
            this.originalFieldType = fieldType;
        }
        ComboBox comboBox = new ComboBox();
        for (Object value2 : fieldType.getAllowedValues()) {
            comboBox.getItems().add((Object)value2.toString());
        }
        if (this.providedValue.isPresent()) {
            Object fixedValue = this.providedValue.get();
            this.values.get(this.id).set(fixedValue);
            comboBox.setValue((Object)fixedValue.toString());
            comboBox.setDisable(true);
        } else {
            fieldType.getDefaultValue().ifPresentOrElse(value -> {
                comboBox.setValue((Object)value.toString());
                this.setFieldValue(value.toString());
            }, () -> {
                String value = fieldType.getAllowedValues().size() == 1 ? fieldType.getAllowedValues().iterator().next().toString() : "";
                comboBox.setValue((Object)value);
                this.setFieldValue(value);
            });
            comboBox.valueProperty().addListener((observable, oldValue, newValue) -> this.setFieldValue((String)newValue));
            this.originalFieldType.getInfo().ifPresent(info -> comboBox.setTooltip(new Tooltip(info)));
        }
        this.result = comboBox;
        this.focusTarget = comboBox;
    }

    public void handle(FieldTypeWithValidator<?> fieldType) throws FieldTypeException {
        if (this.originalFieldType == null) {
            this.originalFieldType = fieldType;
        }
        fieldType.getDelegatee().accept((FieldTypeVisitor)this);
    }

    private void setFieldValue(String newValue) {
        try {
            Object value = this.originalFieldType.postInput(this.id, newValue);
            this.values.get(this.id).set(value);
            this.validationHandler.accept("");
        }
        catch (InputProviderException e) {
            this.values.get(this.id).set(null);
            this.validationHandler.accept(e.getMessage());
        }
    }
}

