/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.gui;

import de.fhdw.gaming.core.domain.DefaultGameBuilderFactoryProvider;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.util.GameBuilderFactoryWrapper;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.gui.GameRunner;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.gui.GuiObserverFactory;
import de.fhdw.gaming.gui.InteractiveDialogInputProvider;
import de.fhdw.gaming.gui.LogObserver;
import de.fhdw.gaming.gui.util.FXUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Application;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class Main
extends Application {
    private static final String APP_NAME = "FHDW Gaming GUI";
    private static final double GOLDEN_RATIO = 1.618;
    private static final String PARAM_GAME = "game";
    private List<GuiObserver> observers;
    private BorderPane rootPane;
    private ListView<String> log;
    private HBox startPageButtonPane;
    private VBox gamePageButtonPane;
    private SimpleObjectProperty<GameRunner> gameRunner;
    private SimpleBooleanProperty gameRunning;
    private SimpleBooleanProperty gameFinished;
    private Optional<GameBuilderFactory> lastGameBuilderFactory;
    private Optional<GameBuilder> lastGameBuilder;
    private int nextGameId;

    public void start(Stage primaryStage) {
        this.observers = Collections.synchronizedList(GuiObserverFactory.getInstances().stream().map(GuiObserverFactory::createObserver).collect(Collectors.toUnmodifiableList()));
        this.gameRunner = new SimpleObjectProperty();
        this.gameRunning = new SimpleBooleanProperty(false);
        this.gameFinished = new SimpleBooleanProperty(false);
        this.lastGameBuilderFactory = Optional.empty();
        this.lastGameBuilder = Optional.empty();
        this.nextGameId = 1;
        this.createUi(primaryStage);
    }

    private void createUi(Stage stage) {
        Application.setUserAgentStylesheet((String)"MODENA");
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        double height = bounds.getHeight() * 3.0 / 5.0;
        double width = Math.min(bounds.getWidth(), height * 1.618);
        this.rootPane = new BorderPane();
        this.createStartPageButtons(stage);
        this.createGamePageButtons(stage);
        this.rootPane.setCenter((Node)this.startPageButtonPane);
        Node logPane = this.createLogPane();
        this.rootPane.setBottom(logPane);
        Scene scene = new Scene((Parent)this.rootPane, width, height);
        stage.setTitle(APP_NAME);
        stage.setScene(scene);
        stage.sizeToScene();
        stage.show();
        stage.setMinWidth(stage.getWidth());
        stage.setMinHeight(stage.getHeight());
        stage.setMaximized(true);
        stage.setOnCloseRequest(event -> {
            this.stopGame();
            this.leaveGame();
        });
    }

    private void createStartPageButtons(Stage stage) {
        final Button newGameButton = Main.createNewGameButton();
        newGameButton.setOnAction(event -> this.startNewGame(stage));
        final Button exitButton = Main.createExitButton();
        exitButton.setOnAction(event -> stage.close());
        DoubleBinding prefWidthProperty = new DoubleBinding(){
            {
                this.bind(new Observable[]{newGameButton.heightProperty()});
                this.bind(new Observable[]{exitButton.heightProperty()});
            }

            protected double computeValue() {
                return Math.max(newGameButton.getHeight(), exitButton.getHeight());
            }
        };
        DoubleBinding prefHeightProperty = new DoubleBinding(){
            {
                this.bind(new Observable[]{newGameButton.widthProperty()});
                this.bind(new Observable[]{exitButton.widthProperty()});
            }

            protected double computeValue() {
                return Math.max(newGameButton.getWidth(), exitButton.getWidth());
            }
        };
        newGameButton.prefWidthProperty().bind((ObservableValue)prefWidthProperty);
        exitButton.prefWidthProperty().bind((ObservableValue)prefWidthProperty);
        newGameButton.prefHeightProperty().bind((ObservableValue)prefHeightProperty);
        exitButton.prefHeightProperty().bind((ObservableValue)prefHeightProperty);
        this.startPageButtonPane = new HBox();
        this.startPageButtonPane.getChildren().addAll((Object[])new Node[]{newGameButton, exitButton});
        HBox.setHgrow((Node)newGameButton, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)exitButton, (Priority)Priority.ALWAYS);
    }

    private void createGamePageButtons(Stage stage) {
        final Button startOrPauseGameButton = Main.createContinueOrPauseGameButton((ObservableBooleanValue)this.gameRunning);
        final Button stopGameButton = Main.createStopGameButton();
        final Button restartGameButton = Main.createRestartGameButton();
        final Button leaveGameButton = Main.createLeaveGameButton();
        DoubleBinding prefWidthProperty = new DoubleBinding(){
            {
                this.bind(new Observable[]{startOrPauseGameButton.heightProperty()});
                this.bind(new Observable[]{stopGameButton.heightProperty()});
                this.bind(new Observable[]{restartGameButton.heightProperty()});
                this.bind(new Observable[]{leaveGameButton.heightProperty()});
            }

            protected double computeValue() {
                return Stream.of(startOrPauseGameButton.getHeight(), stopGameButton.getHeight(), restartGameButton.getHeight(), leaveGameButton.getHeight()).max(Double::compareTo).orElseThrow();
            }
        };
        startOrPauseGameButton.prefWidthProperty().bind((ObservableValue)prefWidthProperty);
        stopGameButton.prefWidthProperty().bind((ObservableValue)prefWidthProperty);
        restartGameButton.prefWidthProperty().bind((ObservableValue)prefWidthProperty);
        leaveGameButton.prefWidthProperty().bind((ObservableValue)prefWidthProperty);
        startOrPauseGameButton.disableProperty().bind((ObservableValue)this.gameRunner.isNull().or((ObservableBooleanValue)this.gameFinished));
        stopGameButton.disableProperty().bind((ObservableValue)this.gameRunner.isNull().or((ObservableBooleanValue)this.gameFinished));
        restartGameButton.disableProperty().bind((ObservableValue)this.gameRunner.isNull().or((ObservableBooleanValue)this.gameFinished.not()));
        leaveGameButton.disableProperty().bind((ObservableValue)this.gameRunner.isNull().or((ObservableBooleanValue)this.gameFinished.not()));
        this.gamePageButtonPane = new VBox();
        this.gamePageButtonPane.getChildren().addAll((Object[])new Node[]{startOrPauseGameButton, stopGameButton, restartGameButton, leaveGameButton});
        this.gamePageButtonPane.setFillWidth(false);
        VBox.setVgrow((Node)startOrPauseGameButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)stopGameButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)restartGameButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)leaveGameButton, (Priority)Priority.ALWAYS);
        startOrPauseGameButton.setOnAction(event -> {
            if (this.gameRunning.get()) {
                this.pauseGame();
                this.log.getItems().add((Object)"Game paused.");
            } else {
                this.continueGame();
                this.log.getItems().add((Object)"Game continued.");
            }
        });
        stopGameButton.setOnAction(event -> {
            this.stopGame();
            this.log.getItems().add((Object)"Game stopped.");
        });
        restartGameButton.setOnAction(event -> {
            this.stopGame();
            this.restartGame(stage);
            this.log.getItems().add((Object)"Game restarted.");
        });
        leaveGameButton.setOnAction(event -> {
            this.stopGame();
            this.leaveGame();
            this.log.getItems().add((Object)"Game left.");
        });
    }

    private static Button createContinueOrPauseGameButton(ObservableBooleanValue mode) {
        return FXUtil.createTwoModeButtonWithSVGImage(mode, new FXUtil.ButtonDescriptor().text("Continue").description("Continues the game.").icon("media-playback-start"), new FXUtil.ButtonDescriptor().text("Pause").description("Pauses the game.").icon("media-playback-pause"));
    }

    private static Button createStopGameButton() {
        return FXUtil.createButtonWithSVGImage(new FXUtil.ButtonDescriptor().text("Stop").description("Stops the game.").icon("media-playback-stop"));
    }

    private static Button createRestartGameButton() {
        return FXUtil.createButtonWithSVGImage(new FXUtil.ButtonDescriptor().text("Restart").description("Restarts the game.").icon("media-skip-backward"));
    }

    private static Button createLeaveGameButton() {
        return FXUtil.createButtonWithSVGImage(new FXUtil.ButtonDescriptor().text("Leave").description("Leaves the game.").icon("media-eject"));
    }

    private static Button createNewGameButton() {
        return FXUtil.createButtonWithSVGImage(new FXUtil.ButtonDescriptor().text("New").description("Starts a new game.").icon("media-mount"));
    }

    private static Button createExitButton() {
        return FXUtil.createButtonWithSVGImage(new FXUtil.ButtonDescriptor().text("Exit").description("Exits application.").icon("system-shutdown"));
    }

    private Node createLogPane() {
        this.log = new ListView();
        this.log.setEditable(false);
        this.log.setPrefHeight(200.0);
        this.log.getItems().addListener(c -> this.log.scrollTo(this.log.getItems().size() - 1));
        VBox vBox = new VBox(new Node[]{this.log});
        vBox.setPadding(new Insets(5.0));
        vBox.setAlignment(Pos.BOTTOM_CENTER);
        vBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderStroke.DEFAULT_WIDTHS)}));
        VBox.setVgrow(this.log, (Priority)Priority.NEVER);
        LogObserver.INSTANCE.setLog(this.log);
        return vBox;
    }

    private void startNewGame(Stage stage) {
        GridPane gamePane = new GridPane();
        gamePane.setPrefSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.rootPane.setCenter((Node)gamePane);
        this.rootPane.setRight((Node)this.gamePageButtonPane);
        try {
            GameBuilder gameBuilder;
            if (this.lastGameBuilder.isPresent()) {
                gameBuilder = this.lastGameBuilder.orElseThrow();
            } else {
                GameBuilderFactory gameBuilderFactory = this.determineGameBuilderFactory(stage);
                gameBuilder = gameBuilderFactory.createGameBuilder(gameBuilderFactory.extendInputProvider((InputProvider)new InteractiveDialogInputProvider((Window)stage)));
                this.lastGameBuilder = Optional.of(gameBuilder);
            }
            this.gameRunner.set((Object)new GameRunner(this.observers, gameBuilder.build(this.nextGameId++), gamePane));
            this.gameRunning.bind((ObservableValue)((GameRunner)this.gameRunner.get()).runningProperty());
            this.gameFinished.bind((ObservableValue)((GameRunner)this.gameRunner.get()).finishedProperty());
            ((GameRunner)this.gameRunner.get()).startGame();
            ((Node)this.gamePageButtonPane.getChildren().get(0)).requestFocus();
        }
        catch (Exception e) {
            FXUtil.showAlert((Window)stage, Alert.AlertType.ERROR, e.getMessage());
            this.leaveGame();
        }
    }

    private void continueGame() {
        ((GameRunner)this.gameRunner.get()).continueGame();
    }

    private void pauseGame() {
        ((GameRunner)this.gameRunner.get()).pauseGame();
    }

    private void stopGame() {
        if (this.gameRunner.get() != null) {
            ((GameRunner)this.gameRunner.get()).abortGame();
        }
    }

    private void restartGame(Stage stage) {
        if (this.gameRunner.get() != null) {
            ((GameRunner)this.gameRunner.get()).abortGame();
            ((GameRunner)this.gameRunner.get()).terminate();
        }
        this.gameRunner.set(null);
        this.gameRunning.unbind();
        this.gameFinished.unbind();
        this.gameRunning.set(false);
        this.gameFinished.set(false);
        this.startNewGame(stage);
    }

    private void leaveGame() {
        if (this.gameRunner.get() != null) {
            ((GameRunner)this.gameRunner.get()).terminate();
        }
        this.gameRunner.set(null);
        this.gameRunning.unbind();
        this.gameFinished.unbind();
        this.gameRunning.set(false);
        this.gameFinished.set(false);
        this.lastGameBuilder = Optional.empty();
        this.lastGameBuilderFactory = Optional.empty();
        this.rootPane.setCenter((Node)this.startPageButtonPane);
        this.rootPane.setRight(null);
        ((Node)this.startPageButtonPane.getChildren().get(0)).requestFocus();
    }

    private GameBuilderFactory determineGameBuilderFactory(Stage stage) throws InputProviderException {
        if (this.lastGameBuilderFactory.isPresent()) {
            return this.lastGameBuilderFactory.orElseThrow();
        }
        LinkedHashSet<GameBuilderFactoryWrapper> gameBuilderFactories = new LinkedHashSet<GameBuilderFactoryWrapper>();
        for (GameBuilderFactory gameBuilderFactory : new DefaultGameBuilderFactoryProvider().getGameBuilderFactories()) {
            gameBuilderFactories.add(new GameBuilderFactoryWrapper(gameBuilderFactory));
        }
        InteractiveDialogInputProvider inputProvider = new InteractiveDialogInputProvider((Window)stage);
        inputProvider.needObject(PARAM_GAME, "Which game to play", Optional.empty(), gameBuilderFactories);
        Map data = inputProvider.requestData("Competition parameters");
        this.lastGameBuilderFactory = Optional.of((GameBuilderFactory)data.get(PARAM_GAME));
        return this.lastGameBuilderFactory.orElseThrow();
    }

    public static void main(String[] parameters) {
        Locale.setDefault(Locale.ENGLISH);
        Main.launch(Main.class, (String[])parameters);
    }
}

