/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.contest.ui;

import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.BooleanFieldType;
import de.fhdw.gaming.core.ui.type.FieldType;
import de.fhdw.gaming.core.ui.type.IntegerFieldType;
import de.fhdw.gaming.core.ui.type.ObjectFieldType;
import de.fhdw.gaming.core.ui.type.StringFieldType;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class InteractiveStreamInputProvider
implements InputProvider {
    private final BufferedReader in;
    private final PrintStream out;
    private final Map<String, NeededDataEntry> neededData;
    private final Map<String, Object> providedData;

    public InteractiveStreamInputProvider(InputStream in, OutputStream out) {
        this.in = new BufferedReader(new InputStreamReader(in, Charset.defaultCharset()));
        this.out = new PrintStream(out, true, Charset.defaultCharset());
        this.neededData = new LinkedHashMap<String, NeededDataEntry>();
        this.providedData = new LinkedHashMap<String, Object>();
    }

    private InteractiveStreamInputProvider(BufferedReader in, PrintStream out) {
        this.in = in;
        this.out = out;
        this.neededData = new LinkedHashMap<String, NeededDataEntry>();
        this.providedData = new LinkedHashMap<String, Object>();
    }

    @SafeVarargs
    public final InteractiveStreamInputProvider needString(String id, String prompt, Optional<String> defaultValue, Validator<String> ... validators) {
        this.neededData.put(id, new NeededDataEntry(prompt, new StringFieldType(defaultValue).validateBy(validators)));
        return this;
    }

    public InteractiveStreamInputProvider fixedString(String id, String fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    @SafeVarargs
    public final InteractiveStreamInputProvider needInteger(String id, String prompt, Optional<Integer> defaultValue, Validator<Integer> ... validators) {
        this.neededData.put(id, new NeededDataEntry(prompt, new IntegerFieldType(defaultValue).validateBy(validators)));
        return this;
    }

    public InteractiveStreamInputProvider fixedInteger(String id, Integer fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    @SafeVarargs
    public final InteractiveStreamInputProvider needBoolean(String id, String prompt, Optional<Boolean> defaultValue, Validator<Boolean> ... validators) {
        this.neededData.put(id, new NeededDataEntry(prompt, new BooleanFieldType(defaultValue).validateBy(validators)));
        return this;
    }

    public InteractiveStreamInputProvider fixedBoolean(String id, Boolean fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    public InteractiveStreamInputProvider needObject(String id, String prompt, Optional<Object> defaultValue, Set<?> objectSet) {
        this.neededData.put(id, new NeededDataEntry(prompt, (FieldType<?>)new ObjectFieldType(defaultValue, objectSet)));
        return this;
    }

    public InteractiveStreamInputProvider fixedObject(String id, Object fixedValue) {
        this.providedData.put(id, fixedValue);
        return this;
    }

    public Map<String, Object> requestData(String title) throws InputProviderException {
        this.out.println(title);
        this.out.println("-".repeat(title.length()));
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, NeededDataEntry> entry : this.neededData.entrySet()) {
            result.put(entry.getKey(), this.requestField(entry.getKey(), entry.getValue()));
        }
        this.out.println();
        return result;
    }

    private Object requestField(String id, NeededDataEntry neededDataEntry) throws InputProviderException {
        while (true) {
            Object value;
            FieldType<?> fieldType = neededDataEntry.getFieldType();
            Optional validationInfo = fieldType.getInfo();
            this.out.printf("%s%s%s: ", neededDataEntry.getPrompt(), validationInfo.map(s -> " {" + s + "}").orElse(""), fieldType.getDefaultValue().map(o -> " [" + o + "]").orElse(""));
            if (this.providedData.containsKey(id)) {
                value = this.providedData.get(id);
                this.out.println(value);
                return value;
            }
            fieldType.preInput(id);
            value = InteractiveStreamInputProvider.readLine(this.in);
            try {
                if (((String)value).isEmpty() && fieldType.getDefaultValue().isPresent()) {
                    return fieldType.getDefaultValue().get();
                }
                return fieldType.postInput(id, ((String)value).strip());
            }
            catch (InputProviderException e) {
                this.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    private static String readLine(BufferedReader reader) throws InputProviderException {
        String value;
        try {
            value = reader.readLine();
        }
        catch (IOException e) {
            throw new InputProviderException("Failed to read input: " + e.getMessage(), (Throwable)e);
        }
        if (value == null) {
            throw new InputProviderException("End of input.");
        }
        return value;
    }

    public InputProvider getNext(Map<String, Object> lastDataSet) {
        return new InteractiveStreamInputProvider(this.in, this.out);
    }

    private static final class NeededDataEntry {
        private final String prompt;
        private final FieldType<?> fieldType;

        NeededDataEntry(String prompt, FieldType<?> fieldType) {
            this.prompt = prompt;
            this.fieldType = fieldType;
        }

        String getPrompt() {
            return this.prompt;
        }

        FieldType<?> getFieldType() {
            return this.fieldType;
        }
    }
}

