/*
 * Decompiled with CFR 0.152.
 */
package maschine;

import auftraege.ProduktionsAuftrag;
import auftraege.auftragsBildungsParameter.BeilagenArten;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Beilagenart;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import util.exceptions.BeilagenAnzahlOutOfBoundsException;

public class BegrenzteBeilagenArten {
    public static final BegrenzteBeilagenArten EMPTY = new BegrenzteBeilagenArten(Collections.unmodifiableSet(new HashSet()), 0);
    private final Set<Beilagenart> beilagenarten;
    private final int begrenzung;

    public int getBegrenzung() {
        return this.begrenzung;
    }

    public BegrenzteBeilagenArten(Set<Beilagenart> beilagenarten, int begrenzung) {
        this.beilagenarten = beilagenarten;
        this.begrenzung = begrenzung;
    }

    public void addBeilagen(Beilagenart ... neueBeilagenArten) {
        if (Stream.concat(this.beilagenarten.stream(), Arrays.stream(neueBeilagenArten)).distinct().count() > (long)this.begrenzung) {
            throw new BeilagenAnzahlOutOfBoundsException();
        }
        this.beilagenarten.addAll(Arrays.asList(neueBeilagenArten));
    }

    public BegrenzteBeilagenArten copy() {
        return new BegrenzteBeilagenArten(new HashSet<Beilagenart>(this.beilagenarten), this.begrenzung);
    }

    public void manageNecessaryChangesToFitBeilagenArten(ProduktionsAuftrag auftrag) throws BeilagenAnzahlOutOfBoundsException {
        int elementsNoetigZuEntfernen;
        Set<Beilagenart> toBeAdded = auftrag.getBeilagenArten().getBeilagenarten();
        Map<Boolean, List<Beilagenart>> bereitsVorhandeneElementeInAuftrag = toBeAdded.stream().collect(Collectors.partitioningBy(this.beilagenarten::contains));
        Map<Boolean, List<Beilagenart>> bereitsVorhandeneElementeInThis = this.beilagenarten.stream().collect(Collectors.partitioningBy(toBeAdded::contains));
        int idk = bereitsVorhandeneElementeInAuftrag.get(false).size() + this.beilagenarten.size() - this.begrenzung;
        int n = elementsNoetigZuEntfernen = idk < 0 ? 0 : idk;
        if (this.beilagenarten.size() + bereitsVorhandeneElementeInAuftrag.get(false).size() - elementsNoetigZuEntfernen > this.begrenzung) {
            throw new BeilagenAnzahlOutOfBoundsException("In diesem BegrenzteBeilagenArtenObjekt ist nicht gen\u00fcgend Platz f\u00fcr diesen Produktionsauftrag " + auftrag);
        }
        IntStream.range(0, elementsNoetigZuEntfernen).forEach(i -> this.beilagenarten.remove(((List)bereitsVorhandeneElementeInThis.get(false)).get(i)));
        this.beilagenarten.addAll((Collection<Beilagenart>)bereitsVorhandeneElementeInAuftrag.get(false));
    }

    public boolean isNotEditable() {
        return this.begrenzung == 0;
    }

    int calculateUmruestvorgaengeZuNeuerBeilagenArt(BeilagenArten that) {
        return BeilagenArten.createMitErlaubten(this.beilagenarten).calculateUmruestvorgaengeZuNeuerBeilagenArt(that, this.begrenzung);
    }
}

