/*
 * Decompiled with CFR 0.152.
 */
package zeit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import util.CollectionHelper;
import zeit.Kalender;
import zeit.KalenderEintragNichtErlaubtException;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragGenerell;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.KalenderEintragVisitor;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;
import zeit.eintraege.Zeitraum;

public class MitarbeiterKalender
extends Kalender {
    private static final int BEGINN_KERNARBEITSZEIT = 8;
    private static final int ENDE_KERNARBEITSZEIT = 16;
    private static final KalenderEintragTyp DEFAULT_TYP = KalenderEintragTyp.ANWESEND;
    private static final Collection<KalenderEintragTyp> ERLAUBTE_TYPEN = new HashSet<KalenderEintragTyp>();

    @Override
    protected void pruefeKalenderEintrag(KalenderEintrag eintrag) {
        if (!ERLAUBTE_TYPEN.contains((Object)eintrag.getTyp())) {
            throw new KalenderEintragNichtErlaubtException(String.format("Der Typ %s ist nicht erlaubt f\u00fcr einen Mitarbeiterkalender", eintrag));
        }
        if (eintrag.accept(new KalenderEintragVisitor<Boolean>(){

            @Override
            public Boolean handle(MaschinenBelegungEintrag maschinenBelegungEintrag) {
                return true;
            }

            @Override
            public Boolean handle(MenschBelegungEintrag menschBelegungEintrag) {
                return false;
            }

            @Override
            public Boolean handle(KalenderEintragGenerell kalenderEintragGenerell) {
                return false;
            }
        }).booleanValue()) {
            throw new KalenderEintragNichtErlaubtException("Der \u00fcbergebene MaschinenBelegungsEintrag kann einem Mitarbeiterkalender nicht hinzugef\u00fcgt werden!");
        }
    }

    @Override
    protected Optional<KalenderEintrag> createDefaultEintragZuTag(LocalDate tag) {
        return Optional.of(this.createKernarbeitszeitEintrag(tag));
    }

    private KalenderEintrag createKernarbeitszeitEintrag(LocalDate tag) {
        LocalDateTime von = tag.atTime(8, 0);
        LocalDateTime bis = tag.atTime(16, 0);
        return KalenderEintragGenerell.create(von, bis, DEFAULT_TYP);
    }

    @Override
    public long getArbeitszeit(LocalDate tag, ChronoUnit einheit) {
        Collection<Zeitraum> anwesenheitsZeitraeume = this.berechneAnwesenheitsZeitraeume(tag, einheit);
        Collection<Zeitraum> anwesenheitenOhneAbwesenheiten = this.vermindereAnwesenheitenUmAbwesenheiten(anwesenheitsZeitraeume, tag);
        return anwesenheitenOhneAbwesenheiten.stream().mapToLong(zeitraum -> einheit.between(zeitraum.getVon(), zeitraum.getBis())).sum();
    }

    private Collection<Zeitraum> vermindereAnwesenheitenUmAbwesenheiten(Collection<Zeitraum> anwesenheitsZeitraeume, LocalDate tag) {
        HashSet<Zeitraum> result = new HashSet<Zeitraum>();
        Set abwesenheiten = this.getEintraegeZuTag(tag).stream().filter(kalenderEintrag -> kalenderEintrag.getTyp() == KalenderEintragTyp.KRANK).map(KalenderEintrag::getZeitraum).collect(Collectors.toSet());
        anwesenheitsZeitraeume.forEach(anwesenheitsZeitraum -> result.addAll(anwesenheitsZeitraum.entferneZeitraeume(abwesenheiten)));
        return result;
    }

    private Collection<Zeitraum> berechneAnwesenheitsZeitraeume(LocalDate tag, ChronoUnit einheit) {
        KalenderEintrag kernarbeitszeitEintrag = this.createKernarbeitszeitEintrag(tag);
        Set<Zeitraum> result = CollectionHelper.createSet(kernarbeitszeitEintrag.getZeitraum());
        Set anwesenheiten = this.getEintraegeZuTag(tag).stream().filter(KalenderEintrag::isVerfuegbar).collect(Collectors.toSet());
        for (KalenderEintrag anwesenheit : anwesenheiten) {
            if (kernarbeitszeitEintrag.contains(anwesenheit)) continue;
            if (kernarbeitszeitEintrag.getZeitraum().keineUeberschneidungAusserPunktuell(anwesenheit.getZeitraum())) {
                result.add(anwesenheit.getZeitraum());
                continue;
            }
            result.addAll(anwesenheit.getZeitraum().subtract(kernarbeitszeitEintrag.getZeitraum()));
        }
        return result;
    }

    public Set<MenschBelegungEintrag> getBelegungen() {
        final HashSet<MenschBelegungEintrag> result = new HashSet<MenschBelegungEintrag>();
        for (Set<KalenderEintrag> eintraege : this.getEintraege().values()) {
            for (KalenderEintrag eintrag : eintraege) {
                eintrag.accept(new KalenderEintragVisitor<Void>(){

                    @Override
                    public Void handle(MaschinenBelegungEintrag maschinenBelegungEintrag) {
                        return null;
                    }

                    @Override
                    public Void handle(MenschBelegungEintrag menschBelegungEintrag) {
                        result.add(menschBelegungEintrag);
                        return null;
                    }

                    @Override
                    public Void handle(KalenderEintragGenerell kalenderEintragGenerell) {
                        return null;
                    }
                });
            }
        }
        return result;
    }

    static {
        ERLAUBTE_TYPEN.add(KalenderEintragTyp.ANWESEND);
        ERLAUBTE_TYPEN.add(KalenderEintragTyp.ABWESEND);
        ERLAUBTE_TYPEN.add(KalenderEintragTyp.BELEGT);
        ERLAUBTE_TYPEN.add(KalenderEintragTyp.KRANK);
    }
}

