/*
 * Decompiled with CFR 0.152.
 */
package zeit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import javax.measure.Quantity;
import javax.measure.quantity.Time;
import util.exceptions.KeineVerfuegbarkeitException;
import zeit.Kalender;
import zeit.eintraege.BelegungsEintrag;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.Zeitraum;

public interface TypMitKalender {
    public Kalender getKalender();

    default public void addBelegungsEintrag(BelegungsEintrag eintrag) {
        this.getKalender().addEintrag(eintrag);
    }

    default public boolean istVerfuegbar(LocalDateTime von, LocalDateTime bis) {
        return this.getKalender().isVerfuegbar(von, bis);
    }

    default public long getArbeitszeit(LocalDate tag, ChronoUnit einheit) {
        return this.getKalender().getArbeitszeit(tag, einheit);
    }

    default public LocalDateTime getFruehesteVerfuegbarkeit(LocalDateTime abZeitpunkt, Quantity<Time> benoetigteZeit, LocalDateTime slaFrist) throws KeineVerfuegbarkeitException {
        return this.getKalender().getFruehesteVerfuegbarkeit(abZeitpunkt, benoetigteZeit, slaFrist);
    }

    default public Collection<Zeitraum> getVerfuegbarkeiten(LocalDateTime abZeitpunkt, Quantity<Time> benoetigteZeit, LocalDateTime slaFrist) {
        return this.getKalender().getVerfuegbarkeiten(abZeitpunkt, benoetigteZeit, slaFrist);
    }

    default public Collection<KalenderEintrag> getEintraegeZuTag(LocalDate tag) {
        return this.getKalender().getEintraegeZuTagOhneSerienTermine(tag);
    }

    default public Collection<KalenderEintrag> getAlleEintraege(Zeitraum zeitraum, KalenderEintragTyp ... filter) {
        return this.getKalender().getAlleEintraege(zeitraum, filter);
    }
}

