/*
 * Decompiled with CFR 0.152.
 */
package maschine.faehigkeit;

import java.util.EnumSet;
import maschine.faehigkeit.Drucken;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.MaschinenFaehigkeit;
import maschine.faehigkeit.SimplesDrucken;
import maschine.faehigkeit.SimplesKuvertieren;
import maschine.papierart.PapierQuelle;
import material.kuvert.KuvertFormat;

public final class Kuvertieren
extends SimplesKuvertieren {
    private final EnumSet<PapierQuelle> unterstuetzePapierQuellen;
    private final EnumSet<KuvertFormat> unterstuetzePapierFormate;
    private final int anzahlMoeglicherBeilagen;

    public Kuvertieren(String name, EnumSet<PapierQuelle> quelle, EnumSet<KuvertFormat> kuvertFormat) {
        super(name);
        this.unterstuetzePapierQuellen = quelle;
        this.unterstuetzePapierFormate = kuvertFormat;
        this.anzahlMoeglicherBeilagen = 0;
    }

    public Kuvertieren(String name, EnumSet<PapierQuelle> quelle, EnumSet<KuvertFormat> kuvertFormat, int anzahlMoeglicherBeilagen) {
        super(name);
        this.unterstuetzePapierQuellen = quelle;
        this.unterstuetzePapierFormate = kuvertFormat;
        this.anzahlMoeglicherBeilagen = anzahlMoeglicherBeilagen;
    }

    @Override
    public boolean erfuellt(MaschinenFaehigkeit anforderung) {
        return anforderung.accept(new FaehigkeitVisitor<Boolean>(){

            @Override
            public Boolean handle(Drucken drucken) {
                return false;
            }

            @Override
            public Boolean handle(Kuvertieren kuvertieren) {
                return Kuvertieren.this.unterstuetzePapierQuellen.containsAll(kuvertieren.unterstuetzePapierQuellen) && Kuvertieren.this.unterstuetzePapierFormate.containsAll(kuvertieren.unterstuetzePapierFormate);
            }

            @Override
            public Boolean handle(SimplesDrucken simplesDrucken) {
                return false;
            }

            @Override
            public Boolean handle(SimplesKuvertieren simplesKuvertieren) {
                return true;
            }
        });
    }

    public boolean supports(PapierQuelle papierQuelle) {
        return this.unterstuetzePapierQuellen.contains((Object)papierQuelle);
    }

    public boolean supports(KuvertFormat kuvertFormat) {
        return this.unterstuetzePapierFormate.contains(kuvertFormat);
    }

    public int getAnzahlMoeglicherBeilagen() {
        return this.anzahlMoeglicherBeilagen;
    }

    @Override
    public boolean erfuelltKuvertFormat(KuvertFormat kuvertFormat) {
        return this.unterstuetzePapierFormate.contains(kuvertFormat);
    }

    @Override
    public <T> T accept(FaehigkeitVisitor<T> visitor) {
        return visitor.handle(this);
    }

    @Override
    public String toString() {
        return "Kuvertieren";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unterstuetzePapierFormate == null ? 0 : this.unterstuetzePapierFormate.hashCode());
        result = 31 * result + (this.unterstuetzePapierQuellen == null ? 0 : this.unterstuetzePapierQuellen.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SimplesKuvertieren && !(obj instanceof Kuvertieren)) {
            return false;
        }
        if (obj instanceof Kuvertieren) {
            Kuvertieren other = (Kuvertieren)obj;
            return this.unterstuetzePapierQuellen.equals(other.unterstuetzePapierQuellen) && this.unterstuetzePapierFormate.equals(other.unterstuetzePapierFormate);
        }
        return false;
    }
}

