/*
 * Decompiled with CFR 0.152.
 */
package maschine.faehigkeit;

import java.util.Objects;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.FaehigkeitVisitor;
import maschine.faehigkeit.FarbDruckTyp;
import material.kuvert.KuvertFormat;

public abstract class MaschinenFaehigkeit
implements Comparable<MaschinenFaehigkeit> {
    private final String name;

    @Override
    public int compareTo(MaschinenFaehigkeit o) {
        return Integer.compare(this.getOrderForSorting(), o.getOrderForSorting());
    }

    public MaschinenFaehigkeit(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean erfuellt(MaschinenFaehigkeit var1);

    public abstract boolean erfuelltDruckTyp(DruckTyp var1);

    public abstract boolean erfuelltFarbDruckTyp(FarbDruckTyp var1);

    public abstract boolean erfuelltKuvertFormat(KuvertFormat var1);

    abstract int getOrderForSorting();

    public abstract <T> T accept(FaehigkeitVisitor<T> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaschinenFaehigkeit that = (MaschinenFaehigkeit)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

