/*
 * Decompiled with CFR 0.152.
 */
package zeit.serientermin;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import zeit.ZeitUtils;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.Zeitraum;
import zeit.serientermin.CreatePassendenKalenderEintragMitZeitraumVisitor;
import zeit.serientermin.SerienTermin;

public final class IntervallSerienTermin
extends SerienTermin {
    private final ComparableQuantity<Time> wiederholungsIntervall;

    private IntervallSerienTermin(KalenderEintrag eintrag, ComparableQuantity<Time> wiederholungsIntervall) {
        super(eintrag);
        this.wiederholungsIntervall = wiederholungsIntervall;
    }

    public static IntervallSerienTermin create(KalenderEintrag eintrag, ComparableQuantity<Time> wiederholungsIntervall) {
        return new IntervallSerienTermin(eintrag, wiederholungsIntervall);
    }

    @Override
    public Collection<KalenderEintrag> berechneKalenderEintraegeZumTag(LocalDate tag) {
        HashSet<KalenderEintrag> eintraege = new HashSet<KalenderEintrag>();
        LocalDateTime laufenderZeitpunktVon = this.getEintrag().getVon();
        if (laufenderZeitpunktVon.toLocalDate().isAfter(tag)) {
            return eintraege;
        }
        while (laufenderZeitpunktVon.toLocalDate().isBefore(tag) || laufenderZeitpunktVon.toLocalDate().equals(tag)) {
            Zeitraum zeitraumZumTag = Zeitraum.create(laufenderZeitpunktVon, this.getEintrag().getDauer());
            if (this.zeitraumAmTag(zeitraumZumTag, tag)) {
                eintraege.add(this.erstellePassendenKalenderEintrag(zeitraumZumTag));
            }
            laufenderZeitpunktVon = ZeitUtils.addTime(laufenderZeitpunktVon, this.wiederholungsIntervall);
        }
        return eintraege;
    }

    private KalenderEintrag erstellePassendenKalenderEintrag(Zeitraum zeitraumZumTag) {
        return this.getEintrag().accept(new CreatePassendenKalenderEintragMitZeitraumVisitor(zeitraumZumTag));
    }
}

