/*
 * Decompiled with CFR 0.152.
 */
package produktionsauftrag;

import auftraege.Dokumentenklasse;
import auftraege.ServiceLevelAgreement;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.BlattAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Id;
import java.time.LocalDateTime;
import java.util.Optional;
import util.ClassObjectMap;
import util.Numberable;
import util.exceptions.SollteNichtPassierenException;

class DokumentenklasseBuilder {
    private final LocalDateTime eingangszeitpunkt;
    private final ClassObjectMap<DokumentenklassenVariable> variablen;
    private int bereitsEingeplanteBlaetter = 0;

    DokumentenklasseBuilder(Dokumentenklasse k) {
        this.variablen = k.getVariablen();
        this.eingangszeitpunkt = k.getEingangsZeitpunkt();
    }

    Dokumentenklasse baue(double faktor) {
        ClassObjectMap variablenCopy = this.variablen.copy();
        int eingeplanteBlaetter = (int)((double)((BlattAnzahl)this.variablen.get(BlattAnzahl.class).orElseThrow(() -> new SollteNichtPassierenException("Die Blattanzahl IST da!"))).intValue() * faktor);
        variablenCopy.put((Object)BlattAnzahl.create((int)eingeplanteBlaetter));
        this.setBereitsEingeplanteBlaetter(eingeplanteBlaetter);
        return new Dokumentenklasse(variablenCopy, this.eingangszeitpunkt);
    }

    Dokumentenklasse baueRest() {
        return this.baue((double)this.getRestlicheBlaetter() / (double)this.getAnzahlBlaetter());
    }

    int getRestlicheBlaetter() {
        return this.getAnzahlBlaetter() - this.getBereitsEingeplanteBlaetter();
    }

    int getBereitsEingeplanteBlaetter() {
        return this.bereitsEingeplanteBlaetter;
    }

    void setBereitsEingeplanteBlaetter(Integer bereitsEingeplanteBlaetter) {
        this.bereitsEingeplanteBlaetter = bereitsEingeplanteBlaetter;
    }

    int getAnzahlBlaetter() {
        return this.variablen.get(BlattAnzahl.class).map(Numberable::intValue).orElse(0);
    }

    public ServiceLevelAgreement getSla() {
        return this.variablen.get(ServiceLevelAgreement.class).orElse(ServiceLevelAgreement.MAX_VALUE);
    }

    ClassObjectMap<DokumentenklassenVariable> getVariablen() {
        return this.variablen;
    }

    public <T extends DokumentenklassenVariable> Optional<T> getVariable(Class<T> clazz) {
        return this.variablen.get(clazz);
    }

    public String toString() {
        return "DokumentenklassenBuilder{" + this.variablen.get(Id.class).map(Object::toString).orElse(this.variablen.toString()) + '}';
    }

    public LocalDateTime getEingangszeitpunkt() {
        return this.eingangszeitpunkt;
    }
}

