/*
 * Decompiled with CFR 0.152.
 */
package tagesplanung;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import auftraege.auftragsBildungsParameter.abstraction.ProduktionsauftragsParameter;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import maschine.Maschine;
import material.MaterialMitMessung;
import mensch.Mitarbeiter;
import produktionsauftrag.ProduktionsAuftragServiceImpl;
import produktionsauftrag.ProduktionsAuftragsService;
import rollenbelegung.ErmittelteBelegungen;
import rollenbelegung.MaschinenRollenbelegungService;
import rollenbelegung.Produktionsplaner;
import rollenbelegung.SortierParameter.MaschinenRollenbelegungServiceParameter;
import rollenbelegung.SortierParameter.MaschinenSortierParameter.MaschinenSortierParameter;
import rollenbelegung.SortierParameter.MitarbeiterSortierParameter.MitarbeiterSortierParameter;
import rollenbelegung.SortierParameter.ProduktionsAuftragsSortierParameter.ProduktionsAuftragSortierParameter;
import rollenbelegung.SortierParameter.ZuordnungsParameter;
import simulation.SimulationsErgebnis;
import simulation.SimulationsErgebnisBuilder;
import simulation.SimulationsService;
import simulation.SimulationsServiceImpl;
import simulation.exceptions.SimulationsException;
import tagesplanung.TagesplanungsService;
import util.Pair;

public class TagesplanungsServiceImpl
implements TagesplanungsService {
    private final ProduktionsAuftragsService produktionsAuftragsService;
    private final MaschinenRollenbelegungService maschinenRollenbelegungService;
    private final SimulationsService simulationsService;
    private final LocalDateTime startZeit;

    public TagesplanungsServiceImpl() {
        this(LocalDateTime.now());
    }

    public TagesplanungsServiceImpl(LocalDateTime startZeit) {
        this.startZeit = startZeit;
        this.produktionsAuftragsService = new ProduktionsAuftragServiceImpl();
        this.maschinenRollenbelegungService = new Produktionsplaner();
        this.simulationsService = new SimulationsServiceImpl();
    }

    @Override
    public Pair<Collection<Dokumentenklasse>, SimulationsErgebnis> planeUndSimuliere(Collection<Dokumentenklasse> dokumentenklassen, Set<ProduktionsauftragsParameter> produktionsauftragsParameter, List<Maschine> maschinen, List<Mitarbeiter> mitarbeiter, MaschinenRollenbelegungServiceParameter maschinenRollenbelegungServiceParameter, Collection<MaterialMitMessung<?>> verfuegbaresMaterial) throws SimulationsException {
        Pair<Collection<Dokumentenklasse>, List<ProduktionsAuftrag>> ergebnisErstelleProduktionsauftraege = this.produktionsAuftragsService.erstelleProduktionsauftraege(produktionsauftragsParameter, dokumentenklassen);
        Collection nichtZugeordneteDokumentenklassen = (Collection)ergebnisErstelleProduktionsauftraege.getFirst();
        List erstellteProduktionsauftraege = (List)ergebnisErstelleProduktionsauftraege.getSecond();
        ErmittelteBelegungen ermittelteBelegungen = this.maschinenRollenbelegungService.findeBelegungAberErzeugeKeineKalendereintraege(maschinen, mitarbeiter, erstellteProduktionsauftraege, maschinenRollenbelegungServiceParameter);
        SimulationsErgebnis simulationsErgebnis = this.simulationsService.pruefeUndSimuliereProduktionsplanung(verfuegbaresMaterial, ermittelteBelegungen);
        return Pair.create((Object)nichtZugeordneteDokumentenklassen, (Object)simulationsErgebnis);
    }

    @Override
    public Pair<Set<ProduktionsauftragsParameter>, MaschinenRollenbelegungServiceParameter> findeOptimaleParameterAus(Collection<Dokumentenklasse> dokumentenklassen, List<Maschine> maschinen, List<Mitarbeiter> mitarbeiter, Collection<MaterialMitMessung<?>> verfuegbaresMaterial, Set<ProduktionsauftragsParameter> produktionsauftragsParameter, MaschinenRollenbelegungServiceParameter maschinenRollenbelegungServiceParameter) {
        HashMap<Pair, Pair> ergebnisParameterMap = new HashMap<Pair, Pair>();
        List<Pair<Set<ProduktionsauftragsParameter>, MaschinenRollenbelegungServiceParameter>> parameterVariationen = this.erzeugeParameterVariationenAus(produktionsauftragsParameter, maschinenRollenbelegungServiceParameter);
        for (Pair<Set<ProduktionsauftragsParameter>, MaschinenRollenbelegungServiceParameter> parameterVariation : parameterVariationen) {
            Set produktionsauftragsParameterVariation = (Set)parameterVariation.getFirst();
            MaschinenRollenbelegungServiceParameter maschinenRollenbelegungServiceParameterVariation = (MaschinenRollenbelegungServiceParameter)parameterVariation.getSecond();
            try {
                Pair<Collection<Dokumentenklasse>, SimulationsErgebnis> ergebnisPlaneUndSimuliere = this.planeUndSimuliere(dokumentenklassen, produktionsauftragsParameterVariation, maschinen, mitarbeiter, maschinenRollenbelegungServiceParameterVariation, verfuegbaresMaterial);
                ergebnisParameterMap.put(Pair.create((Object)ergebnisPlaneUndSimuliere.getFirst(), (Object)ergebnisPlaneUndSimuliere.getSecond()), Pair.create((Object)produktionsauftragsParameterVariation, (Object)maschinenRollenbelegungServiceParameterVariation));
            }
            catch (SimulationsException simulationsException) {}
        }
        Pair<Collection<Dokumentenklasse>, SimulationsErgebnis> bestesErgebnis = this.findeBestesErgebnis(ergebnisParameterMap.keySet());
        return (Pair)ergebnisParameterMap.get(bestesErgebnis);
    }

    @Override
    public Pair<Collection<Dokumentenklasse>, SimulationsErgebnis> planeUndSimuliereMitOptimalenParameternAus(Collection<Dokumentenklasse> dokumentenklassen, List<Maschine> maschinen, List<Mitarbeiter> mitarbeiter, Collection<MaterialMitMessung<?>> verfuegbaresMaterial, Set<ProduktionsauftragsParameter> produktionsauftragsParameter, MaschinenRollenbelegungServiceParameter maschinenRollenBelegungServiceParameter) {
        Pair<Set<ProduktionsauftragsParameter>, MaschinenRollenbelegungServiceParameter> optimaleParameter = this.findeOptimaleParameterAus(dokumentenklassen, maschinen, mitarbeiter, verfuegbaresMaterial, produktionsauftragsParameter, maschinenRollenBelegungServiceParameter);
        return this.planeUndSimuliere(dokumentenklassen, (Set)optimaleParameter.getFirst(), maschinen, mitarbeiter, (MaschinenRollenbelegungServiceParameter)optimaleParameter.getSecond(), verfuegbaresMaterial);
    }

    public List<Pair<Set<ProduktionsauftragsParameter>, MaschinenRollenbelegungServiceParameter>> erzeugeParameterVariationenAus(Set<ProduktionsauftragsParameter> produktionsauftragsParameter, MaschinenRollenbelegungServiceParameter maschinenRollenbelegungServiceParameter) {
        return this.kombiniereProduktionsauftragsParameterUndMaschinenRollenbelegungServiceParameter(this.erzeugeProduktionsauftragsParameterVariationenAus(produktionsauftragsParameter), this.erzeugeMaschinenRollenbelegungServiceParameterVariationenAus(maschinenRollenbelegungServiceParameter));
    }

    private List<Pair<Set<ProduktionsauftragsParameter>, MaschinenRollenbelegungServiceParameter>> kombiniereProduktionsauftragsParameterUndMaschinenRollenbelegungServiceParameter(List<Set<ProduktionsauftragsParameter>> produktionsauftragsParameterVaritionen, List<MaschinenRollenbelegungServiceParameter> maschinenRollenbelegungServiceParameterVaritionen) {
        return produktionsauftragsParameterVaritionen.stream().flatMap(produktionsauftragsParameter -> maschinenRollenbelegungServiceParameterVaritionen.stream().map(maschinenRollenbelegungServiceParameter -> Pair.create((Object)produktionsauftragsParameter, (Object)maschinenRollenbelegungServiceParameter))).collect(Collectors.toList());
    }

    private List<Set<ProduktionsauftragsParameter>> erzeugeProduktionsauftragsParameterVariationenAus(Set<ProduktionsauftragsParameter> produktionsauftragsParameter) {
        return new ArrayList<Set<ProduktionsauftragsParameter>>(Sets.powerSet(produktionsauftragsParameter));
    }

    private List<MaschinenRollenbelegungServiceParameter> erzeugeMaschinenRollenbelegungServiceParameterVariationenAus(MaschinenRollenbelegungServiceParameter maschinenRollenbelegungServiceParameter) {
        List produktionsAuftragSortierParameterVariationen = Sets.powerSet(new LinkedHashSet<ProduktionsAuftragSortierParameter>(maschinenRollenbelegungServiceParameter.getProduktionsAuftragsSortierungsarten())).stream().map(ArrayList::new).collect(Collectors.toList());
        List maschinenSortierParameterVariationen = Sets.powerSet(new LinkedHashSet<MaschinenSortierParameter>(maschinenRollenbelegungServiceParameter.getMaschinenSortierungsarten())).stream().map(ArrayList::new).collect(Collectors.toList());
        List mitarbeiterSortierParameterVariationen = Sets.powerSet(new LinkedHashSet<MitarbeiterSortierParameter>(maschinenRollenbelegungServiceParameter.getMitarbeiterSortierungsarten())).stream().map(ArrayList::new).collect(Collectors.toList());
        List<ZuordnungsParameter> zuordnungsParameterVariationen = Arrays.asList(ZuordnungsParameter.values());
        return produktionsAuftragSortierParameterVariationen.stream().flatMap(produktionsSortierVariation -> maschinenSortierParameterVariationen.stream().flatMap(maschinenSortierVariation -> mitarbeiterSortierParameterVariationen.stream().flatMap(mitarbeiterSortierVariation -> zuordnungsParameterVariationen.stream().map(zuordnungsParameterVariation -> new MaschinenRollenbelegungServiceParameter((List<ProduktionsAuftragSortierParameter>)produktionsSortierVariation, (List<MaschinenSortierParameter>)maschinenSortierVariation, (List<MitarbeiterSortierParameter>)mitarbeiterSortierVariation, (ZuordnungsParameter)((Object)((Object)((Object)((Object)zuordnungsParameterVariation)))), maschinenRollenbelegungServiceParameter.getStartZeit()))))).collect(Collectors.toList());
    }

    private Pair<Collection<Dokumentenklasse>, SimulationsErgebnis> findeBestesErgebnis(Set<Pair<Collection<Dokumentenklasse>, SimulationsErgebnis>> uebrigeDokumentenklassenUndSimulationsErgebnisse) {
        HashMap bestesErgebnisMap = new HashMap();
        SimulationsErgebnisBuilder builder = SimulationsErgebnisBuilder.create();
        uebrigeDokumentenklassenUndSimulationsErgebnisse.forEach(e -> {
            Collection uebrigeDokumentenklassen = (Collection)e.getFirst();
            SimulationsErgebnis simulationsErgebnis = (SimulationsErgebnis)e.getSecond();
            uebrigeDokumentenklassen.addAll(simulationsErgebnis.getNichtEingehalteneSlas());
            builder.pruefErgebnis(simulationsErgebnis.getPruefErgebnis()).verbrauchteZeitProProduktionsAuftrag(simulationsErgebnis.getVerbrauchteZeitProProduktionsAuftrag()).auslastungProMaschine(simulationsErgebnis.getAuslastungProMaschine()).auslastungProMitarbeiter(simulationsErgebnis.getAuslastungProMitarbeiter()).nichtEingehalteneSlas(uebrigeDokumentenklassen);
            bestesErgebnisMap.put(builder.build(), e);
        });
        SimulationsErgebnis bestesSimulationsErgebnis = this.findeBestesSimulationsErgebnis(bestesErgebnisMap.keySet());
        return (Pair)bestesErgebnisMap.get(bestesSimulationsErgebnis);
    }

    private SimulationsErgebnis findeBestesSimulationsErgebnis(Set<SimulationsErgebnis> simulationsErgebnisse) {
        return (SimulationsErgebnis)simulationsErgebnisse.stream().max(SimulationsErgebnis::compareTo).orElseThrow(() -> new SimulationsException("Das \u00fcbergebene Set ist leer!"));
    }
}

