/*
 * Decompiled with CFR 0.152.
 */
package simulation.SimulationsHelper;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import maschine.Maschine;
import mensch.Mitarbeiter;
import rollenbelegung.ErmittelteBelegungen;
import rollenbelegung.MaschinenBelegung;
import rollenbelegung.MitarbeiterBelegung;
import simulation.SimulationsHelper.Auslastung;
import simulation.SimulationsHelper.SimulationsKonstanten;
import simulation.exceptions.SimulationsException;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import zeit.TypMitKalender;
import zeit.eintraege.BelegungsEintrag;
import zeit.eintraege.KalenderEintrag;

public final class AuslastungsHelper {
    private final ChronoUnit javaZeitEinheit;
    private final Unit<Time> zeitEinheit;

    private AuslastungsHelper(ChronoUnit berechnungsZeitEinheit) {
        this.javaZeitEinheit = berechnungsZeitEinheit;
        this.zeitEinheit = SimulationsKonstanten.getZeitEinheit(berechnungsZeitEinheit);
    }

    public static AuslastungsHelper create(ChronoUnit berechnungsZeitEinheit) {
        return new AuslastungsHelper(berechnungsZeitEinheit);
    }

    public static AuslastungsHelper create() {
        return new AuslastungsHelper(SimulationsKonstanten.DEFAULT_JAVA_ZEIT_EINHEIT);
    }

    public Map<Maschine, Auslastung> simuliereAuslastungProMaschine(ErmittelteBelegungen ermittelteBelegungen) {
        LocalDateTime firstWorkDay = this.ermittleErstenTagImPlanungsZeitraum(ermittelteBelegungen);
        LocalDateTime lastWorkDay = this.ermittleLetztenTagImPlanungsZeitraum(ermittelteBelegungen);
        return ermittelteBelegungen.getMaschinenbelegungen().entrySet().stream().map(belegungenProMaschine -> this.berechneAuslastungProMaschine((Map.Entry<Maschine, MaschinenBelegung>)belegungenProMaschine, firstWorkDay, lastWorkDay)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<Mitarbeiter, Auslastung> simuliereAuslastungProMitarbeiter(ErmittelteBelegungen ermittelteBelegungen) {
        LocalDateTime firstWorkDay = this.ermittleErstenTagImPlanungsZeitraum(ermittelteBelegungen);
        LocalDateTime lastWorkDay = this.ermittleLetztenTagImPlanungsZeitraum(ermittelteBelegungen);
        return ermittelteBelegungen.getMitarbeiterbelegungen().entrySet().stream().map(belegungenProMitarbeiter -> this.berechneAuslastungProMitarbeiter((Map.Entry<Mitarbeiter, MitarbeiterBelegung>)belegungenProMitarbeiter, firstWorkDay, lastWorkDay)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map.Entry<Mitarbeiter, Auslastung> berechneAuslastungProMitarbeiter(Map.Entry<Mitarbeiter, MitarbeiterBelegung> belegungenProMitarbeiter, LocalDateTime firstWorkDay, LocalDateTime lastWorkDay) {
        ComparableQuantity<Time> geleistetetArbeitszeitDesMitarbeiters = this.berechneDauerDerBelegungen(belegungenProMitarbeiter.getValue().getBelegung());
        ComparableQuantity<Time> verfuegbareArbeitszeitDesMitarbeiters = this.berechneArbeitszeit((TypMitKalender)belegungenProMitarbeiter.getKey(), firstWorkDay, lastWorkDay);
        return new AbstractMap.SimpleEntry<Mitarbeiter, Auslastung>(belegungenProMitarbeiter.getKey(), Auslastung.create(geleistetetArbeitszeitDesMitarbeiters, verfuegbareArbeitszeitDesMitarbeiters));
    }

    private Map.Entry<Maschine, Auslastung> berechneAuslastungProMaschine(Map.Entry<Maschine, MaschinenBelegung> belegungenProMaschine, LocalDateTime firstWorkDay, LocalDateTime lastWorkDay) {
        ComparableQuantity<Time> geleisteteZeitDerMaschineInStunden = this.berechneDauerDerBelegungen(belegungenProMaschine.getValue().getBelegung());
        ComparableQuantity<Time> maximalVerfuegbareStunden = this.berechneArbeitszeit((TypMitKalender)belegungenProMaschine.getKey(), firstWorkDay, lastWorkDay);
        return new AbstractMap.SimpleEntry<Maschine, Auslastung>(belegungenProMaschine.getKey(), Auslastung.create(geleisteteZeitDerMaschineInStunden, maximalVerfuegbareStunden));
    }

    private ComparableQuantity<Time> berechneDauerDerBelegungen(Collection<? extends BelegungsEintrag> belegungsEintraege) {
        return belegungsEintraege.stream().map(KalenderEintrag::getDauer).reduce(SimulationsKonstanten.NEUTRALE_ZEIT, ComparableQuantity::add);
    }

    private ComparableQuantity<Time> berechneArbeitszeit(TypMitKalender typMitKalender, LocalDateTime firstWorkDay, LocalDateTime lastWorkDay) {
        long sum = 0L;
        LocalDateTime workDay = firstWorkDay;
        while (!workDay.isAfter(lastWorkDay)) {
            sum += typMitKalender.getArbeitszeit(workDay.toLocalDate(), this.getJavaZeitEinheit());
            workDay = workDay.plusDays(1L);
        }
        return Quantities.getQuantity((Number)sum, this.getZeitEinheit());
    }

    private LocalDateTime ermittleErstenTagImPlanungsZeitraum(ErmittelteBelegungen ermittelteBelegungen) {
        return ermittelteBelegungen.getMitarbeiterbelegungen().values().stream().flatMap(mitarbeiterBelegung -> mitarbeiterBelegung.getBelegung().stream()).map(KalenderEintrag::getVon).min(LocalDateTime::compareTo).orElseThrow(() -> new SimulationsException("Simulation nicht m\u00f6glich, wenn keine Belegungen geplant wurden"));
    }

    private LocalDateTime ermittleLetztenTagImPlanungsZeitraum(ErmittelteBelegungen ermittelteBelegungen) {
        return ermittelteBelegungen.getMitarbeiterbelegungen().values().stream().flatMap(mitarbeiterBelegung -> mitarbeiterBelegung.getBelegung().stream()).map(KalenderEintrag::getBis).max(LocalDateTime::compareTo).orElseThrow(() -> new SimulationsException("Simulation nicht m\u00f6glich, wenn keine Belegungen geplant wurden"));
    }

    private ChronoUnit getJavaZeitEinheit() {
        return this.javaZeitEinheit;
    }

    private Unit<Time> getZeitEinheit() {
        return this.zeitEinheit;
    }
}

