/*
 * Decompiled with CFR 0.152.
 */
package rollenbelegung.SortierParameter.MaschinenSortierParameter;

import java.util.Comparator;
import java.util.List;
import maschine.Maschine;
import maschine.faehigkeit.Drucken;
import rollenbelegung.SortierParameter.MaschinenSortierParameter.MaschinenSortierParameter;
import rollenbelegung.SortierParameter.SortierReihenfolge;

public final class SortDruckTyp
extends MaschinenSortierParameter {
    private static SortDruckTyp instanceAbsteigend;
    private static SortDruckTyp instanceAufsteigend;

    private SortDruckTyp(SortierReihenfolge sortierReihenfolge) {
        super(sortierReihenfolge);
    }

    public static SortDruckTyp getInstanceAufsteigend() {
        if (instanceAufsteigend == null) {
            instanceAufsteigend = new SortDruckTyp(SortierReihenfolge.AUFSTEIGEND);
        }
        return instanceAufsteigend;
    }

    public static SortDruckTyp getInstanceAbsteigend() {
        if (instanceAbsteigend == null) {
            instanceAbsteigend = new SortDruckTyp(SortierReihenfolge.ABSTEIGEND);
        }
        return instanceAbsteigend;
    }

    private Comparator<Maschine> getComparator() {
        return new Comparator<Maschine>(){

            @Override
            public int compare(Maschine m1, Maschine m2) {
                if (!m1.getDruckEigenschaften().isPresent()) {
                    return -1;
                }
                if (!m2.getDruckEigenschaften().isPresent()) {
                    return 1;
                }
                return ((Drucken)m1.getDruckEigenschaften().get()).getUnterstuetzteDrucktypen().stream().max(Comparator.naturalOrder()).map(Enum::ordinal).orElse(-1).compareTo(((Drucken)m2.getDruckEigenschaften().get()).getUnterstuetzteDrucktypen().stream().max(Comparator.naturalOrder()).map(Enum::ordinal).orElse(-1));
            }
        };
    }

    @Override
    public void specialSort(List<Maschine> maschinen) {
        maschinen.sort(this.getComparator());
    }
}

