/*
 * Decompiled with CFR 0.152.
 */
package servicekommandos.wochenplanung;

import auftraege.Dokumentenklasse;
import auftraege.VoraussichtlicheDokumentenklasse;
import java.util.Collection;
import java.util.List;
import maschine.Maschine;
import planung.MittelfristigePlanung;
import planung.SchichtZeit;
import planung.wochenplanung.StandardStrategie;
import schnittstelle.kommandoArchitektur.KommandoOhneExceptionMitResultat;
import schnittstelle.kommandoArchitektur.KommandoVisitor;
import util.Fraction;
import util.exceptions.PPSException;
import zeit.eintraege.Zeitraum;

public final class ErstelleMittelfristigePlanungKommando
extends KommandoOhneExceptionMitResultat<MittelfristigePlanung> {
    private final Zeitraum zeitraum;
    private final Collection<SchichtZeit> schichtZeiten;
    private final List<Dokumentenklasse> dokumentenklassen;
    private final Collection<VoraussichtlicheDokumentenklasse> voraussichtlicheDokumentenklassen;
    private final Collection<Maschine> maschinen;
    private final Fraction produktionssatz;

    private ErstelleMittelfristigePlanungKommando(Zeitraum zeitraum, Collection<SchichtZeit> schichtZeiten, List<Dokumentenklasse> dokumentenklassen, Collection<VoraussichtlicheDokumentenklasse> voraussichtlicheDokumentenklassen, Collection<Maschine> maschinen, Fraction produktionssatz) {
        this.schichtZeiten = schichtZeiten;
        this.zeitraum = zeitraum;
        this.dokumentenklassen = dokumentenklassen;
        this.voraussichtlicheDokumentenklassen = voraussichtlicheDokumentenklassen;
        this.maschinen = maschinen;
        this.produktionssatz = produktionssatz;
    }

    public static ErstelleMittelfristigePlanungKommando create(Zeitraum zeitraum, Collection<SchichtZeit> schichtZeiten, List<Dokumentenklasse> dokumentenklassen, Collection<VoraussichtlicheDokumentenklasse> voraussichtlicheDokumentenklassen, Collection<Maschine> maschinen, Fraction produktionssatz) {
        return new ErstelleMittelfristigePlanungKommando(zeitraum, schichtZeiten, dokumentenklassen, voraussichtlicheDokumentenklassen, maschinen, produktionssatz);
    }

    protected MittelfristigePlanung doIt() {
        return StandardStrategie.getInstance().erstelleMittelfristigePlanung(this.zeitraum, this.schichtZeiten, this.dokumentenklassen, this.voraussichtlicheDokumentenklassen, this.maschinen, this.produktionssatz);
    }

    public void accept(KommandoVisitor v) throws PPSException {
    }
}

