/*
 * Decompiled with CFR 0.152.
 */
package planung.wochenplanung;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import auftraege.VoraussichtlicheDokumentenklasse;
import auftraege.auftragsBildungsParameter.MaxKundenauftraege;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import maschine.Maschine;
import maschine.faehigkeit.MaschinenFaehigkeit;
import planung.Begruendung;
import planung.MittelfristigePlanung;
import planung.Schicht;
import planung.SchichtZeit;
import planung.wochenplanung.PlanungsStrategie;
import produktionsauftrag.ProduktionsAuftragServiceImpl;
import rollenbelegung.Produktionsplaner;
import util.Fraction;
import util.Pair;
import util.exceptions.SollteNichtPassierenException;
import zeit.eintraege.UhrzeitZeitraum;
import zeit.eintraege.Zeitraum;

public final class StandardStrategie
implements PlanungsStrategie {
    private static volatile StandardStrategie instance;

    private StandardStrategie() {
    }

    public static StandardStrategie getInstance() {
        if (instance == null) {
            instance = new StandardStrategie();
        }
        return instance;
    }

    @Override
    public MittelfristigePlanung erstelleMittelfristigePlanung(Zeitraum zeitraum, Collection<SchichtZeit> schichtZeiten, List<Dokumentenklasse> dokumentenklassen, Collection<VoraussichtlicheDokumentenklasse> voraussichtlicheDokumentenklassen, Collection<Maschine> maschinen, Fraction produktionssatz) {
        List<Schicht> schichten = this.erstelleSchichtenFuerZeitraum(schichtZeiten, zeitraum);
        schichten.sort(Comparator.comparing(schicht -> schicht.getZeitraum().getVon()));
        CompletableFuture<Pair> bestCase = CompletableFuture.supplyAsync(() -> this.erstelleOptimalenSchichtplan(this.copy(schichten), maschinen, new ArrayList<Dokumentenklasse>(dokumentenklassen), voraussichtlicheDokumentenklassen, produktionssatz, MittelfristigePlanung.SZENARIO.BestCase, schichtZeiten));
        CompletableFuture<Pair> averageCase = CompletableFuture.supplyAsync(() -> this.erstelleOptimalenSchichtplan(this.copy(schichten), maschinen, new ArrayList<Dokumentenklasse>(dokumentenklassen), voraussichtlicheDokumentenklassen, produktionssatz, MittelfristigePlanung.SZENARIO.AverageCase, schichtZeiten));
        CompletableFuture<Pair> worstCase = CompletableFuture.supplyAsync(() -> this.erstelleOptimalenSchichtplan(this.copy(schichten), maschinen, new ArrayList<Dokumentenklasse>(dokumentenklassen), voraussichtlicheDokumentenklassen, produktionssatz, MittelfristigePlanung.SZENARIO.WorstCase, schichtZeiten));
        try {
            return MittelfristigePlanung.create((List)((List)bestCase.get().getFirst()), (Map)((Map)bestCase.get().getSecond()), (List)((List)averageCase.get().getFirst()), (Map)((Map)averageCase.get().getSecond()), (List)((List)worstCase.get().getFirst()), (Map)((Map)worstCase.get().getSecond()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SollteNichtPassierenException("es ist ein Fehler beim Ausf\u00fchren des CompletableFuture passiert :(");
        }
    }

    private List<Schicht> copy(List<Schicht> schichten) {
        return schichten.stream().map(Schicht::copy).collect(Collectors.toList());
    }

    private Pair<List<Schicht>, Map<ProduktionsAuftrag, Begruendung>> erstelleOptimalenSchichtplan(List<Schicht> schichten, Collection<Maschine> maschinen, List<Dokumentenklasse> dokumentenklassen, Collection<VoraussichtlicheDokumentenklasse> voraussichtlicheDokumentenklassen, Fraction produktionssatz, MittelfristigePlanung.SZENARIO szenario, Collection<SchichtZeit> schichtzeiten) {
        HashMap<ProduktionsAuftrag, Begruendung> uebrigeAuftraege = new HashMap<ProduktionsAuftrag, Begruendung>();
        List<ProduktionsAuftrag> produktionsAuftraege = this.dokumentenklassenToProduktionsauftraege(dokumentenklassen);
        produktionsAuftraege.sort(Comparator.comparing(ProduktionsAuftrag::getFrist));
        for (Schicht schicht : schichten) {
            switch (szenario) {
                case BestCase: {
                    break;
                }
                case AverageCase: {
                    produktionsAuftraege.addAll(this.dokumentenklassenToProduktionsauftraege(voraussichtlicheDokumentenklassen.stream().map(v -> v.toDokumentenklasseAverageCase(schicht.getZeitraum().getVon(), this.berechneAnzahlDerSchichtenInDieDieseVoraussichtlicheDokumentenklasseFallenKoennte((VoraussichtlicheDokumentenklasse)v, schichtzeiten))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())));
                    break;
                }
                case WorstCase: {
                    produktionsAuftraege.addAll(this.dokumentenklassenToProduktionsauftraege(voraussichtlicheDokumentenklassen.stream().map(v -> v.toDokumentenklasseWorstCase(schicht.getZeitraum().getVon())).filter(Optional::isPresent).map(Optional::get).filter(dokumentenklasse -> produktionsAuftraege.stream().noneMatch(produktionsAuftrag -> produktionsAuftrag.getDokumentenklassen().stream().anyMatch(dokumentenklasseDesProduktionsauftrags -> dokumentenklasse.getId().equals(dokumentenklasseDesProduktionsauftrags.getId())))).collect(Collectors.toList())));
                    break;
                }
                default: {
                    throw new SollteNichtPassierenException("Hier muss ein weiteres Szenario aus MittelfristigePlanung.SZENARIO implementiert werden");
                }
            }
            uebrigeAuftraege.putAll(this.befuelleSchicht(schicht, produktionsAuftraege, maschinen, produktionssatz));
        }
        produktionsAuftraege.forEach(p -> uebrigeAuftraege.put((ProduktionsAuftrag)p, Begruendung.AlleSchichtenVoll));
        return Pair.create(schichten, uebrigeAuftraege);
    }

    private int berechneAnzahlDerSchichtenInDieDieseVoraussichtlicheDokumentenklasseFallenKoennte(VoraussichtlicheDokumentenklasse v, Collection<SchichtZeit> schichtzeiten) {
        return this.erstelleSchichtenFuerZeitraum(schichtzeiten, v.getZeitraum()).size();
    }

    private List<ProduktionsAuftrag> dokumentenklassenToProduktionsauftraege(List<Dokumentenklasse> dokumentenklassen) {
        return (List)new ProduktionsAuftragServiceImpl().erstelleProduktionsauftraege(Stream.of(new MaxKundenauftraege(Integer.valueOf(1))).collect(Collectors.toSet()), dokumentenklassen).getSecond();
    }

    private Map<ProduktionsAuftrag, Begruendung> befuelleSchicht(Schicht schicht, List<ProduktionsAuftrag> produktionsAuftraege, Collection<Maschine> maschinen, Fraction produktionssatz) {
        HashMap<ProduktionsAuftrag, Begruendung> uebrigeAuftraege = new HashMap<ProduktionsAuftrag, Begruendung>();
        produktionsAuftraege.sort(Comparator.comparing(ProduktionsAuftrag::getFrist));
        Produktionsplaner produktionsplaner = new Produktionsplaner();
        Iterator<ProduktionsAuftrag> produktionsAuftragIterator = produktionsAuftraege.iterator();
        block0: while (produktionsAuftragIterator.hasNext()) {
            ProduktionsAuftrag produktionsAuftrag = produktionsAuftragIterator.next();
            if (produktionsAuftrag.getFrist().isBefore(schicht.getZeitraum().getBis())) {
                uebrigeAuftraege.put(produktionsAuftrag, Begruendung.SLAVerpennt);
                produktionsAuftragIterator.remove();
                continue;
            }
            List entries = produktionsplaner.getQualifizierteMaschinenProBenoetigteFaehigkeit(maschinen, produktionsAuftrag).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
            Iterator listeVonMaschinenListenProBenoetigteFaehigkeitIterator = entries.iterator();
            while (listeVonMaschinenListenProBenoetigteFaehigkeitIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)listeVonMaschinenListenProBenoetigteFaehigkeitIterator.next();
                List maschinenListe = ((Collection)entry.getValue()).stream().sorted(Comparator.comparing(maschine -> maschine.berechneBenoetigteZeit(produktionsAuftrag))).collect(Collectors.toList());
                if (maschinenListe.isEmpty()) {
                    uebrigeAuftraege.put(produktionsAuftrag, Begruendung.erstelleBegruendungFuerFaehigkeit((MaschinenFaehigkeit)((MaschinenFaehigkeit)entry.getKey())));
                    maschinen.stream().filter(maschine -> schicht.getDokumentenklassen(maschine).containsAll(produktionsAuftrag.getDokumentenklassen())).forEach(maschine -> ((Collection)schicht.getMaschinenProduktionsauftraegeMap().get(maschine)).remove(produktionsAuftrag));
                    produktionsAuftragIterator.remove();
                    continue block0;
                }
                Maschine maschineDieDenAuftragHabenSollte = null;
                Iterator iterator = maschinenListe.iterator();
                while (iterator.hasNext()) {
                    Maschine maschine2;
                    maschineDieDenAuftragHabenSollte = maschine2 = (Maschine)iterator.next();
                    if (!schicht.addProduktionsauftrag(produktionsAuftrag, maschine2, produktionssatz)) continue;
                    if (listeVonMaschinenListenProBenoetigteFaehigkeitIterator.hasNext()) break;
                    produktionsAuftragIterator.remove();
                    break;
                }
                if (schicht.getDokumentenklassen(maschineDieDenAuftragHabenSollte).containsAll(produktionsAuftrag.getDokumentenklassen())) continue;
                continue block0;
            }
        }
        return uebrigeAuftraege;
    }

    public List<Schicht> erstelleSchichtenFuerZeitraum(Collection<SchichtZeit> schichtZeiten, Zeitraum zeitraum) {
        Map<DayOfWeek, List<SchichtZeit>> wochentagSchichtzeitenMap = schichtZeiten.stream().collect(Collectors.groupingBy(SchichtZeit::getWochentag));
        LinkedList<Schicht> schichtPlan = new LinkedList<Schicht>();
        Collection tagesZeitraeume = zeitraum.splitInEinzelneTage();
        for (Zeitraum tagesZeitraum : tagesZeitraeume) {
            if (!wochentagSchichtzeitenMap.containsKey(tagesZeitraum.getWochentag())) continue;
            List uhrzeitraeumeDesTages = wochentagSchichtzeitenMap.get(tagesZeitraum.getWochentag()).stream().map(SchichtZeit::getUhrzeitRaum).collect(Collectors.toList());
            for (UhrzeitZeitraum current : uhrzeitraeumeDesTages) {
                Schicht schicht;
                if (!tagesZeitraum.getBis().toLocalTime().isAfter(current.getBis()) && !tagesZeitraum.getBis().toLocalTime().equals(current.getBis())) continue;
                if (current.getBis().isAfter(current.getVon())) {
                    LocalDateTime bis = tagesZeitraum.getVon().withHour(current.getBis().getHour()).withMinute(current.getBis().getMinute());
                    LocalDateTime von = tagesZeitraum.getVon().withHour(current.getVon().getHour()).withMinute(current.getVon().getMinute());
                    Zeitraum neueZeitraum = Zeitraum.create((LocalDateTime)von, (LocalDateTime)bis);
                    schicht = Schicht.createOhneMaschinen((Zeitraum)neueZeitraum);
                    schichtPlan.add(schicht);
                    continue;
                }
                LocalDateTime von = tagesZeitraum.getVon().withHour(current.getVon().getHour()).withMinute(current.getVon().getMinute());
                LocalDateTime bis = tagesZeitraum.getVon().plusDays(1L).withHour(current.getBis().getHour()).withMinute(current.getBis().getMinute());
                Zeitraum neueZeitraum2 = Zeitraum.create((LocalDateTime)von, (LocalDateTime)bis);
                schicht = Schicht.createOhneMaschinen((Zeitraum)neueZeitraum2);
                schichtPlan.add(schicht);
            }
        }
        return schichtPlan;
    }
}

