/*
 * Decompiled with CFR 0.152.
 */
package produktionsauftrag;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import auftraege.UnpassendeKlasseException;
import auftraege.auftragsBildungsParameter.BeilagenArten;
import auftraege.auftragsBildungsParameter.BlattAnzahlSpanne;
import auftraege.auftragsBildungsParameter.FarbDruckTypMischbar;
import auftraege.auftragsBildungsParameter.Kunden;
import auftraege.auftragsBildungsParameter.KuvertFormate;
import auftraege.auftragsBildungsParameter.MaxBeilagenarten;
import auftraege.auftragsBildungsParameter.MaxKundenauftraege;
import auftraege.auftragsBildungsParameter.PapierFormate;
import auftraege.auftragsBildungsParameter.Rollenkapazitaet;
import auftraege.auftragsBildungsParameter.SimplexDuplexMischbar;
import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameter;
import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameterVisitor;
import auftraege.auftragsBildungsParameter.abstraction.LimitierenderParameter;
import auftraege.auftragsBildungsParameter.abstraction.LimitierenderParameterVisitor;
import auftraege.auftragsBildungsParameter.abstraction.ProduktionsauftragsParameter;
import auftraege.auftragsBildungsParameter.abstraction.StrategieParameter;
import auftraege.auftragsBildungsParameter.abstraction.StrategieParameterVisitor;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.BlattAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import auftraege.versand.Kunde;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.FarbDruckTyp;
import material.auspraegungen.Papierformat;
import material.kuvert.KuvertFormat;
import produktionsauftrag.DokumentenklasseBuilder;
import produktionsauftrag.FaktorOutOfBoundsException;
import produktionsauftrag.ProduktionsAuftragsService;
import produktionsauftrag.ProduktionsauftragsBuilder;
import util.ClassObjectMap;
import util.Pair;
import util.exceptions.AlreadyExistsException;
import zeit.eintraege.Zeitraum;

public class ProduktionsAuftragServiceImpl
implements ProduktionsAuftragsService {
    private ClassObjectMap<ProduktionsauftragsParameter> parameterMap;

    @Override
    public Pair<Collection<Dokumentenklasse>, List<ProduktionsAuftrag>> erstelleProduktionsauftraege(Set<ProduktionsauftragsParameter> parameter, Collection<Dokumentenklasse> dokumentenKlassen) {
        this.organizeParameters(parameter);
        Map<Boolean, List<Dokumentenklasse>> partitionierteDokumentenklassen = this.filterKlassenByParameter(dokumentenKlassen);
        List<DokumentenklasseBuilder> abzuarbeitendeDokumentenklassenbuilder = partitionierteDokumentenklassen.get(true).stream().map(DokumentenklasseBuilder::new).collect(Collectors.toList());
        List nichtAbzuarbeitendeDokumentenklassenbuilder = partitionierteDokumentenklassen.get(false).stream().map(DokumentenklasseBuilder::new).collect(Collectors.toList());
        List<ProduktionsauftragsBuilder> erstelleProduktionsauftraegeIntern = this.erstelleProduktionsauftraegeIntern(abzuarbeitendeDokumentenklassenbuilder);
        List nichtVerarbeiteteDokumentenklassen = Stream.concat(abzuarbeitendeDokumentenklassenbuilder.stream().filter(bauer -> bauer.getRestlicheBlaetter() > 0), nichtAbzuarbeitendeDokumentenklassenbuilder.stream()).map(DokumentenklasseBuilder::baueRest).collect(Collectors.toList());
        List erstellteProduktionsauftraege = erstelleProduktionsauftraegeIntern.stream().map(ProduktionsauftragsBuilder::baue).collect(Collectors.toList());
        return Pair.create(nichtVerarbeiteteDokumentenklassen, erstellteProduktionsauftraege);
    }

    private Map<Boolean, List<Dokumentenklasse>> filterKlassenByParameter(Collection<Dokumentenklasse> dokumentenKlassen) {
        return dokumentenKlassen.stream().collect(Collectors.partitioningBy(dokumentenklasse -> Stream.concat(this.parameterMap.getBySuperclass(AusschliessenderParameter.class).stream().map(ausschliessenderParameter -> (Boolean)ausschliessenderParameter.accept((AusschliessenderParameterVisitor)new BooleanAusschliessenderParameterVisitor((Dokumentenklasse)dokumentenklasse))), this.parameterMap.getBySuperclass(LimitierenderParameter.class).stream().map(limitierenderParameter -> (Boolean)limitierenderParameter.accept((LimitierenderParameterVisitor)new LimitierenderParameterVisitor<Boolean>(){

            public Boolean handle(MaxKundenauftraege maxKundenauftraege) {
                return maxKundenauftraege.getValue() > 0;
            }

            public Boolean handle(MaxBeilagenarten maxBeilagenarten) {
                return dokumentenklasse.getVariablen().get(BeilagenArten.class).map(BeilagenArten::getBeilagenarten).map(Set::size).map(size -> size <= maxBeilagenarten.getBegrenzung()).orElse(true);
            }

            public Boolean handle(Rollenkapazitaet rollenkapazitaet) {
                return true;
            }
        }))).reduce(Boolean.TRUE, (current, rest) -> current != false && rest != false)));
    }

    private void organizeParameters(Set<ProduktionsauftragsParameter> parameter) {
        this.parameterMap = new ClassObjectMap();
        parameter.forEach(arg_0 -> this.parameterMap.put(arg_0));
    }

    private List<ProduktionsauftragsBuilder> erstelleProduktionsauftraegeIntern(Collection<DokumentenklasseBuilder> nichtKomplettAbgearbeitetenKundenauftraege) {
        List<DokumentenklasseBuilder> collect = this.sortiereNachStrategieParametern(nichtKomplettAbgearbeitetenKundenauftraege);
        return this.erstelleProduktionsauftraegeZuEinemProzesstyp(collect);
    }

    private List<DokumentenklasseBuilder> sortiereNachStrategieParametern(Collection<DokumentenklasseBuilder> nichtKomplettAbgearbeitetenKundenauftraege) {
        return nichtKomplettAbgearbeitetenKundenauftraege.stream().sorted((o1, o2) -> this.parameterMap.getBySuperclass(StrategieParameter.class).stream().sorted(Comparator.comparing(StrategieParameter::holePrioritaet)).map(param -> (Integer)param.accept((StrategieParameterVisitor)new StrategieParameterVisitor<Integer>(){

            public Integer handle(FarbDruckTypMischbar farbDruckTypMischbar) {
                return o1.getVariablen().get(FarbDruckTyp.class).orElse(FarbDruckTyp.Farbdruck).compareTo((Enum)o2.getVariablen().get(FarbDruckTyp.class).orElse(FarbDruckTyp.Farbdruck));
            }

            public Integer handle(SimplexDuplexMischbar simplexDuplexMischbar) {
                return o1.getVariablen().get(DruckTyp.class).orElse(DruckTyp.duplex).compareTo((Enum)o2.getVariablen().get(DruckTyp.class).orElse(DruckTyp.duplex));
            }
        })).reduce((erstes, zweites) -> zweites).orElse(0)).collect(Collectors.toList());
    }

    private List<ProduktionsauftragsBuilder> erstelleProduktionsauftraegeZuEinemProzesstyp(List<DokumentenklasseBuilder> kundenauftraege) {
        ArrayList<ProduktionsauftragsBuilder> produktionsAuftraege = new ArrayList<ProduktionsauftragsBuilder>();
        try {
            this.verarbeitePriorisierteKundenauftraege(kundenauftraege, produktionsAuftraege);
            this.verarbeiteNichtPriorisierteKundenauftraege(kundenauftraege, produktionsAuftraege);
        }
        catch (UnpassendeKlasseException | FaktorOutOfBoundsException | AlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        return produktionsAuftraege;
    }

    private void verarbeiteNichtPriorisierteKundenauftraege(List<DokumentenklasseBuilder> kundenauftraege, List<ProduktionsauftragsBuilder> produktionsAuftraege) throws FaktorOutOfBoundsException, UnpassendeKlasseException, AlreadyExistsException {
        List<DokumentenklasseBuilder> nichtPriorisierteKundenauftraege = kundenauftraege.stream().filter(it -> !this.kundenauftragIstWichtig((DokumentenklasseBuilder)it)).collect(Collectors.toList());
        this.fuelleProduktionsauftrag(produktionsAuftraege, nichtPriorisierteKundenauftraege);
    }

    private void verarbeitePriorisierteKundenauftraege(List<DokumentenklasseBuilder> kundenauftraege, List<ProduktionsauftragsBuilder> produktionsAuftraege) throws FaktorOutOfBoundsException, UnpassendeKlasseException, AlreadyExistsException {
        List<DokumentenklasseBuilder> priorisierteKundenauftraege = kundenauftraege.stream().filter(this::kundenauftragIstWichtig).collect(Collectors.toList());
        if (!priorisierteKundenauftraege.isEmpty()) {
            this.fuelleProduktionsauftragPriorisiert(produktionsAuftraege, priorisierteKundenauftraege);
        }
    }

    private void fuelleProduktionsauftragPriorisiert(List<ProduktionsauftragsBuilder> produktionsAuftraege, List<DokumentenklasseBuilder> priorisierteKundenauftraege) throws AlreadyExistsException, FaktorOutOfBoundsException, UnpassendeKlasseException {
        for (DokumentenklasseBuilder dokumentenklasse : priorisierteKundenauftraege) {
            while (dokumentenklasse.getRestlicheBlaetter() > 0) {
                ProduktionsauftragsBuilder matchingProduktionsauftragsBuilder = this.ermittlePassendenProduktionsauftragsBuilder(produktionsAuftraege, dokumentenklasse);
                if (this.passtKomplettAufRolle(matchingProduktionsauftragsBuilder, dokumentenklasse)) {
                    matchingProduktionsauftragsBuilder.addDokumentenklasse(dokumentenklasse, this.errechneFaktorNochOffeneBlattzahl(dokumentenklasse));
                    continue;
                }
                double verarbeitbarerFaktor = this.errechneVerarbeitbarenFaktor(matchingProduktionsauftragsBuilder, dokumentenklasse);
                matchingProduktionsauftragsBuilder.addDokumentenklasse(dokumentenklasse, verarbeitbarerFaktor);
            }
        }
    }

    private ProduktionsauftragsBuilder ermittlePassendenProduktionsauftragsBuilder(List<ProduktionsauftragsBuilder> produktionsAuftraege, DokumentenklasseBuilder dokumentenklasse) {
        return produktionsAuftraege.stream().filter(produktionsauftrag -> produktionsauftrag.pruefeKompatibilitaet(dokumentenklasse)).filter(produktionsauftrag -> this.errechneVerarbeitbarenFaktor((ProduktionsauftragsBuilder)produktionsauftrag, dokumentenklasse) > 0.0).findFirst().orElseGet(() -> {
            ProduktionsauftragsBuilder newProduktionsauftragsBuilder = new ProduktionsauftragsBuilder(this.parameterMap);
            produktionsAuftraege.add(newProduktionsauftragsBuilder);
            return newProduktionsauftragsBuilder;
        });
    }

    private void fuelleProduktionsauftrag(List<ProduktionsauftragsBuilder> produktionsAuftraege, List<DokumentenklasseBuilder> nichtPriorisierteKundenauftraege) throws FaktorOutOfBoundsException, UnpassendeKlasseException, AlreadyExistsException {
        for (DokumentenklasseBuilder dokumentenklasse : nichtPriorisierteKundenauftraege) {
            while (dokumentenklasse.getRestlicheBlaetter() > 0) {
                ProduktionsauftragsBuilder currentProduktionsAuftrag = this.ermittlePassendenProduktionsauftragsBuilder(produktionsAuftraege, dokumentenklasse);
                if (this.passtKomplettAufRolle(currentProduktionsAuftrag, dokumentenklasse)) {
                    currentProduktionsAuftrag.addDokumentenklasse(dokumentenklasse, this.errechneFaktorNochOffeneBlattzahl(dokumentenklasse));
                    continue;
                }
                double verarbeitbarerFaktor = this.errechneVerarbeitbarenFaktor(currentProduktionsAuftrag, dokumentenklasse);
                currentProduktionsAuftrag.addDokumentenklasse(dokumentenklasse, verarbeitbarerFaktor);
            }
        }
    }

    private double errechneFaktorNochOffeneBlattzahl(DokumentenklasseBuilder dokumentenklasse) {
        return dokumentenklasse.getBereitsEingeplanteBlaetter() == 0 ? 1.0 : (double)dokumentenklasse.getRestlicheBlaetter() / (double)dokumentenklasse.getAnzahlBlaetter();
    }

    private double errechneVerarbeitbarenFaktor(ProduktionsauftragsBuilder produktionsAuftrag, DokumentenklasseBuilder dokumentenklasse) {
        return this.parameterMap.get(Rollenkapazitaet.class).map(Rollenkapazitaet::getKapazitaet).map(kapazitaet -> (double)(kapazitaet - produktionsAuftrag.getBlattZahl()) / (double)dokumentenklasse.getRestlicheBlaetter()).orElse(1.0);
    }

    private boolean bekommeRolleVoll(List<DokumentenklasseBuilder> nichtPriorisierteKundenauftraege) {
        return !nichtPriorisierteKundenauftraege.isEmpty() && this.parameterMap.get(Rollenkapazitaet.class).map(Rollenkapazitaet::getKapazitaet).map(kapazitaet -> nichtPriorisierteKundenauftraege.stream().mapToInt(DokumentenklasseBuilder::getRestlicheBlaetter).sum() >= kapazitaet).orElse(true) != false;
    }

    private boolean passtKomplettAufRolle(ProduktionsauftragsBuilder produktionsAuftrag, DokumentenklasseBuilder dokumentenklasse) {
        return this.parameterMap.get(Rollenkapazitaet.class).map(Rollenkapazitaet::getKapazitaet).map(kapazitaet -> dokumentenklasse.getRestlicheBlaetter() + produktionsAuftrag.getBlattZahl() <= kapazitaet).orElse(true);
    }

    private boolean kundenauftragIstWichtig(DokumentenklasseBuilder dokumentenklasse) {
        return dokumentenklasse.getSla().getFrist(dokumentenklasse.getEingangszeitpunkt()).isBefore(LocalDateTime.now().plusDays(2L));
    }

    private static class BooleanAusschliessenderParameterVisitor
    implements AusschliessenderParameterVisitor<Boolean> {
        private final Dokumentenklasse dokumentenklasse;

        BooleanAusschliessenderParameterVisitor(Dokumentenklasse dokumentenklasse) {
            this.dokumentenklasse = dokumentenklasse;
        }

        public Boolean handle(Kunden kunden) {
            return this.dokumentenklasse.getVariablen().get(Kunde.class).map(arg_0 -> ((Kunden)kunden).contains(arg_0)).orElse(false);
        }

        public Boolean handle(KuvertFormate kuvertFormate) {
            return this.dokumentenklasse.getVariablen().get(KuvertFormat.class).map(arg_0 -> ((KuvertFormate)kuvertFormate).contains(arg_0)).orElse(false);
        }

        public Boolean handle(ProzessModell prozessModell) {
            return this.dokumentenklasse.getVariablen().get(ProzessModell.class).map(arg_0 -> ((ProzessModell)prozessModell).equals(arg_0)).orElse(false);
        }

        public Boolean handle(BeilagenArten beilagenArten) {
            return this.dokumentenklasse.getVariablen().get(BeilagenArten.class).map(e -> beilagenArten.containsAll(e.getBeilagenarten())).orElse(false);
        }

        public Boolean handle(Zeitraum zeitraum) {
            return zeitraum.contains(this.dokumentenklasse.getFrist());
        }

        public Boolean handle(BlattAnzahlSpanne blattAnzahlSpanne) {
            return this.dokumentenklasse.getVariablen().get(BlattAnzahl.class).map(arg_0 -> ((BlattAnzahlSpanne)blattAnzahlSpanne).contains(arg_0)).orElse(false);
        }

        public Boolean handle(DruckTyp druckTyp) {
            return this.dokumentenklasse.getVariablen().get(DruckTyp.class).map(arg_0 -> druckTyp.equals(arg_0)).orElse(false);
        }

        public Boolean handle(PapierFormate papierFormate) {
            return this.dokumentenklasse.getVariablen().get(Papierformat.class).map(arg_0 -> ((PapierFormate)papierFormate).contains(arg_0)).orElse(false);
        }

        public Boolean handle(FarbDruckTyp farbDruckTyp) {
            return this.dokumentenklasse.getVariablen().get(FarbDruckTyp.class).map(arg_0 -> farbDruckTyp.equals(arg_0)).orElse(false);
        }
    }
}

