/*
 * Decompiled with CFR 0.152.
 */
package zeit;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Quantity;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import util.exceptions.KeineVerfuegbarkeitException;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.Zeitraum;
import zeit.serientermin.SerienTermin;

public abstract class Kalender {
    private final Map<LocalDate, Set<KalenderEintrag>> eintraege = new HashMap<LocalDate, Set<KalenderEintrag>>();
    private final Set<SerienTermin> serienTermine = new HashSet<SerienTermin>();

    protected Kalender() {
    }

    public void addEintrag(KalenderEintrag eintrag) {
        this.pruefeKalenderEintrag(eintrag);
        LocalDate tagVon = eintrag.getVon().toLocalDate();
        LocalDate tagBis = eintrag.getBis().toLocalDate();
        this.eintraege.putIfAbsent(tagVon, new HashSet());
        this.eintraege.get(tagVon).add(eintrag);
        LocalDate laufendesDatum = tagVon;
        while (laufendesDatum.isBefore(tagBis)) {
            this.eintraege.putIfAbsent(tagBis, new HashSet());
            this.eintraege.get(tagBis).add(eintrag);
            laufendesDatum = laufendesDatum.plusDays(1L);
        }
    }

    public void removeEintrag(KalenderEintrag eintrag) {
        LocalDate tagVon = eintrag.getVon().toLocalDate();
        LocalDate tagBis = eintrag.getBis().toLocalDate();
        this.eintraege.get(tagVon).remove(eintrag);
        LocalDate laufendesDatum = tagVon;
        while (laufendesDatum.isBefore(tagBis)) {
            this.eintraege.get(tagBis).remove(eintrag);
            laufendesDatum = laufendesDatum.plusDays(1L);
        }
    }

    protected abstract void pruefeKalenderEintrag(KalenderEintrag var1);

    public void erstelleSerienTerminMitWiederholungsIntervall(KalenderEintrag eintrag, ComparableQuantity<Time> wiederholungsIntervall) {
        this.pruefeKalenderEintrag(eintrag);
        this.serienTermine.add(SerienTermin.createSerienterminMitIntervall(eintrag, wiederholungsIntervall));
    }

    public SerienTermin erstelleMonatlichenSerienTermin(KalenderEintrag eintrag) {
        this.pruefeKalenderEintrag(eintrag);
        SerienTermin monatlicherSerientermin = SerienTermin.createMonatlichenSerientermin(eintrag);
        this.serienTermine.add(monatlicherSerientermin);
        return monatlicherSerientermin;
    }

    public Collection<KalenderEintrag> getEintraegeZuTag(LocalDate tag) {
        Collection<KalenderEintrag> eintraegeZuTag = this.getEintraegeZuTagOhneSerienTermine(tag);
        if (this.serienTermine.isEmpty()) {
            return eintraegeZuTag;
        }
        HashSet<KalenderEintrag> result = new HashSet<KalenderEintrag>(eintraegeZuTag);
        this.serienTermine.forEach(serienTermin -> result.addAll(serienTermin.getKalenderEintraegeDesSerienTerminAmTag(tag)));
        return result;
    }

    protected Collection<KalenderEintrag> getEintraegeZuTagOhneSerienTermine(LocalDate tag) {
        Set<KalenderEintrag> result = this.getEintraege().get(tag);
        Optional<KalenderEintrag> defaultEintragZuTag = this.createDefaultEintragZuTag(tag);
        if (Objects.isNull(result)) {
            HashSet eintraegeZuTag = new HashSet();
            defaultEintragZuTag.ifPresent(eintraegeZuTag::add);
            return Collections.unmodifiableCollection(eintraegeZuTag);
        }
        defaultEintragZuTag.ifPresent(result::add);
        return Collections.unmodifiableCollection(result);
    }

    protected abstract Optional<KalenderEintrag> createDefaultEintragZuTag(LocalDate var1);

    public boolean isVerfuegbar(LocalDateTime zeitpunkt) {
        Set eintraegeDieDenZeitpunktbeinhalten = this.getEintraegeZuTag(zeitpunkt.toLocalDate()).stream().filter(eintrag -> eintrag.contains(zeitpunkt)).collect(Collectors.toSet());
        return !eintraegeDieDenZeitpunktbeinhalten.isEmpty() && eintraegeDieDenZeitpunktbeinhalten.stream().allMatch(KalenderEintrag::isVerfuegbar);
    }

    public boolean isVerfuegbar(LocalDateTime von, LocalDateTime bis) {
        return this.isVerfuegbar(von) && this.isVerfuegbar(bis);
    }

    public abstract long getArbeitszeit(LocalDate var1, ChronoUnit var2);

    public Collection<Zeitraum> getVerfuegbarkeiten(LocalDateTime abZeitpunkt, Quantity<Time> benoetigteZeit, LocalDateTime slaFrist) {
        HashSet<Zeitraum> zeitslots = new HashSet<Zeitraum>();
        LocalDateTime laufenderZeitpunkt = abZeitpunkt;
        while (laufenderZeitpunkt.isBefore(slaFrist) || laufenderZeitpunkt.equals(slaFrist)) {
            Collection<KalenderEintrag> alleEintraegeZumTag = this.getEintraegeZuTagOhneSerienTermine(laufenderZeitpunkt.toLocalDate());
            Set<Zeitraum> relevanteAnwesenheiten = this.getRelevanteAnwesenheitenAlsZeitraum(alleEintraegeZumTag, benoetigteZeit);
            Set<Zeitraum> abwesenheiten = this.getAbwesenheitenAlsZeitraeume(alleEintraegeZumTag);
            if (slaFrist.toLocalDate().equals(laufenderZeitpunkt.toLocalDate())) {
                relevanteAnwesenheiten = this.reduziereZeitraeumeWelcheUeberSLAGehen(relevanteAnwesenheiten, slaFrist);
            }
            if (abZeitpunkt.toLocalDate().equals(laufenderZeitpunkt.toLocalDate())) {
                relevanteAnwesenheiten = this.reduziereZeitraeumeWelcheVorAbZeitpunktSind(relevanteAnwesenheiten, abZeitpunkt);
            }
            zeitslots.addAll(this.findeFreieZeitslots(benoetigteZeit, relevanteAnwesenheiten, abwesenheiten));
            laufenderZeitpunkt = laufenderZeitpunkt.plusDays(1L);
        }
        return zeitslots;
    }

    public LocalDateTime getFruehesteVerfuegbarkeit(LocalDateTime abZeitpunkt, Quantity<Time> benoetigteZeit, LocalDateTime slaFrist) throws KeineVerfuegbarkeitException {
        Optional<LocalDateTime> beginnDesErstenZeitslots = this.getVerfuegbarkeiten(abZeitpunkt, benoetigteZeit, slaFrist).stream().map(Zeitraum::getVon).sorted().findFirst();
        if (beginnDesErstenZeitslots.isPresent()) {
            return beginnDesErstenZeitslots.get();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        throw new KeineVerfuegbarkeitException(String.format("Bis zur SLA-Frist %s wurde ab dem Zeitpunkt %s kein freier Zeitslot von %s gefunden.", formatter.format(slaFrist), formatter.format(abZeitpunkt), benoetigteZeit));
    }

    private Collection<Zeitraum> findeFreieZeitslots(Quantity<Time> benoetigteZeit, Set<Zeitraum> relevanteAnwesenheiten, Set<Zeitraum> abwesenheiten) {
        HashSet<Zeitraum> zeitslots = new HashSet<Zeitraum>();
        for (Zeitraum anwesenheitsZeitraum : relevanteAnwesenheiten) {
            Set<Zeitraum> wirklicheAnwesenheiten = anwesenheitsZeitraum.entferneZeitraeume(abwesenheiten);
            zeitslots.addAll(wirklicheAnwesenheiten.stream().filter(zeitraum -> this.dauerDesEintragsKleinerAlsDauer((Zeitraum)zeitraum, benoetigteZeit)).collect(Collectors.toSet()));
        }
        return zeitslots;
    }

    private Set<Zeitraum> reduziereZeitraeumeWelcheVorAbZeitpunktSind(Set<Zeitraum> relevanteAnwesenheiten, LocalDateTime abZeipunkt) {
        HashSet<Zeitraum> reduzierteZeitraeume = new HashSet<Zeitraum>();
        for (Zeitraum anwesenheit : relevanteAnwesenheiten) {
            if (anwesenheit.contains(abZeipunkt)) {
                reduzierteZeitraeume.add(Zeitraum.create(abZeipunkt, anwesenheit.getBis()));
                continue;
            }
            reduzierteZeitraeume.add(anwesenheit);
        }
        return reduzierteZeitraeume;
    }

    private Set<Zeitraum> reduziereZeitraeumeWelcheUeberSLAGehen(Set<Zeitraum> relevanteAnwesenheiten, LocalDateTime slaFrist) {
        HashSet<Zeitraum> reduzierteZeitraeume = new HashSet<Zeitraum>();
        for (Zeitraum anwesenheit : relevanteAnwesenheiten) {
            if (anwesenheit.contains(slaFrist)) {
                reduzierteZeitraeume.add(Zeitraum.create(anwesenheit.getVon(), slaFrist));
                continue;
            }
            reduzierteZeitraeume.add(anwesenheit);
        }
        return reduzierteZeitraeume;
    }

    private Set<Zeitraum> getAbwesenheitenAlsZeitraeume(Collection<KalenderEintrag> eintraegeZuTag) {
        return eintraegeZuTag.stream().filter(KalenderEintrag::isNichtVerfuegbar).map(KalenderEintrag::getZeitraum).collect(Collectors.toSet());
    }

    private Set<Zeitraum> getRelevanteAnwesenheitenAlsZeitraum(Collection<KalenderEintrag> eintraegeZuTag, Quantity<Time> benoetigteZeit) {
        return eintraegeZuTag.stream().filter(KalenderEintrag::isVerfuegbar).filter(kalenderEintrag -> this.dauerDesEintragsKleinerAlsDauer(kalenderEintrag.getZeitraum(), benoetigteZeit)).map(KalenderEintrag::getZeitraum).collect(Collectors.toSet());
    }

    private boolean dauerDesEintragsKleinerAlsDauer(Zeitraum zeitraum, Quantity<Time> benoetigteZeit) {
        int dauerDesEintragsInEinheitDerDauer = zeitraum.getDauer().to(benoetigteZeit.getUnit()).getValue().intValue();
        return dauerDesEintragsInEinheitDerDauer >= benoetigteZeit.getValue().intValue();
    }

    protected Map<LocalDate, Set<KalenderEintrag>> getEintraege() {
        return this.eintraege;
    }

    public Collection<KalenderEintrag> getAlleEintraege(Zeitraum zeitraum, KalenderEintragTyp[] filter) {
        ArrayList<KalenderEintrag> result = new ArrayList<KalenderEintrag>();
        for (Set<KalenderEintrag> kalenderEintraege : this.eintraege.values()) {
            for (KalenderEintrag kalenderEintrag : kalenderEintraege) {
                if (!kalenderEintrag.getZeitraum().ueberschneidet(zeitraum)) continue;
                for (KalenderEintragTyp typ : filter) {
                    if (kalenderEintrag.getTyp().compareTo(typ) != 0) continue;
                    result.add(kalenderEintrag);
                }
            }
        }
        return result;
    }

    public Optional<KalenderEintrag> getLetztenEintragVorZeitpunkt(LocalDateTime zeitpunkt) {
        return Stream.of(this.eintraege.get(zeitpunkt.toLocalDate())).filter(e -> !Objects.isNull(e)).flatMap(Collection::stream).filter(eintrag -> !eintrag.getBis().isAfter(zeitpunkt)).max(Comparator.comparing(KalenderEintrag::getBis));
    }
}

