/*
 * Decompiled with CFR 0.152.
 */
package auftraege.factory;

import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariable;
import auftraege.factory.BeilagenartFactory;
import auftraege.factory.BlattAnzahlFactory;
import auftraege.factory.DirectDokumentenklassenVariablenFactory;
import auftraege.factory.DruckTypFactory;
import auftraege.factory.FarbDruckTypFactory;
import auftraege.factory.IdFactory;
import auftraege.factory.KundeFactory;
import auftraege.factory.KuvertFormatFactory;
import auftraege.factory.PapierformatFactory;
import auftraege.factory.ProzessModellFactory;
import auftraege.factory.SendungsAnzahlFactory;
import auftraege.factory.ServiceLevelAgreementFactory;
import java.util.HashMap;
import java.util.Map;

public enum DokumentenklassenVariablenFactory {
    INSTANCE;

    static final Map<String, DirectDokumentenklassenVariablenFactory> FACTORIES;

    public DokumentenklassenVariable verarbeite(String bezeichnung, String wert) {
        if (FACTORIES.get(bezeichnung) == null) {
            return new UnbekannteVariable(bezeichnung, wert);
        }
        return FACTORIES.get(bezeichnung).parse(wert);
    }

    static {
        FACTORIES = new HashMap<String, DirectDokumentenklassenVariablenFactory>();
        FACTORIES.put("id", IdFactory.INSTANCE);
        FACTORIES.put("FarbDruckTyp", FarbDruckTypFactory.INSTANCE);
        FACTORIES.put("Blattanzahl", BlattAnzahlFactory.INSTANCE);
        FACTORIES.put("DruckTyp", DruckTypFactory.INSTANCE);
        FACTORIES.put("Papierformat", PapierformatFactory.INSTANCE);
        FACTORIES.put("Anzahl Sendungen", SendungsAnzahlFactory.INSTANCE);
        FACTORIES.put("Sendungsanzahl", SendungsAnzahlFactory.INSTANCE);
        FACTORIES.put("Anzahl Blaetter", BlattAnzahlFactory.INSTANCE);
        FACTORIES.put("KuvertFormat", KuvertFormatFactory.INSTANCE);
        FACTORIES.put("Kuvertformat", KuvertFormatFactory.INSTANCE);
        FACTORIES.put("Kunde", KundeFactory.INSTANCE);
        FACTORIES.put("sla", ServiceLevelAgreementFactory.INSTANCE);
        FACTORIES.put("SLA", ServiceLevelAgreementFactory.INSTANCE);
        FACTORIES.put("Beilagen", BeilagenartFactory.INSTANCE);
        FACTORIES.put("Beilagenarten", BeilagenartFactory.INSTANCE);
        FACTORIES.put("Prozessmodell", ProzessModellFactory.INSTANCE);
    }
}

