/*
 * Decompiled with CFR 0.152.
 */
package simulation.SimulationsHelper;

import com.google.common.base.Objects;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import simulation.SimulationsHelper.SimulationsKonstanten;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.unit.Units;
import util.Fraction;

public final class Auslastung {
    private static final Unit<Time> DEFAULT_ZEITEINHEIT = Units.SECOND;
    public static final Auslastung NEUTRAL_AUSLASTUNG = Auslastung.create(SimulationsKonstanten.NEUTRALE_ZEIT, SimulationsKonstanten.NEUTRALE_ZEIT);
    private final ComparableQuantity<Time> geleisteteArbeitszeit;
    private final ComparableQuantity<Time> verfuegbareArbeitszeit;

    private Auslastung(ComparableQuantity<Time> geleisteteArbeitszeit, ComparableQuantity<Time> verfuegbareArbeitszeit) {
        this.geleisteteArbeitszeit = geleisteteArbeitszeit;
        this.verfuegbareArbeitszeit = verfuegbareArbeitszeit;
    }

    public static Auslastung create(ComparableQuantity<Time> geleisteteArbeitszeit, ComparableQuantity<Time> verfuegbareArbeitszeit) {
        return new Auslastung(geleisteteArbeitszeit, verfuegbareArbeitszeit);
    }

    public Fraction asFraction() {
        return Fraction.valueOf((Number)this.geleisteteArbeitszeit.to(DEFAULT_ZEITEINHEIT).getValue().longValue()).divide(Fraction.valueOf((Number)this.verfuegbareArbeitszeit.to(DEFAULT_ZEITEINHEIT).getValue().longValue()));
    }

    public Auslastung add(Auslastung auslastung) {
        return Auslastung.create((ComparableQuantity<Time>)this.geleisteteArbeitszeit.add(auslastung.geleisteteArbeitszeit), (ComparableQuantity<Time>)this.verfuegbareArbeitszeit.add(auslastung.verfuegbareArbeitszeit));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Auslastung)) {
            return false;
        }
        Auslastung that = (Auslastung)o;
        return Objects.equal(this.geleisteteArbeitszeit, that.geleisteteArbeitszeit) && Objects.equal(this.verfuegbareArbeitszeit, that.verfuegbareArbeitszeit);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.geleisteteArbeitszeit, this.verfuegbareArbeitszeit});
    }
}

