/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import auftraege.Dokumentenklasse;
import auftraege.ProduktionsAuftrag;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.measure.Quantity;
import javax.measure.quantity.Time;
import material.Material;
import material.MaterialMitMessung;
import mensch.Mitarbeiter;
import rollenbelegung.ErmittelteBelegungen;
import simulation.PruefErgebnis;
import simulation.PruefErgebnisBuilder;
import simulation.SimulationsErgebnis;
import simulation.SimulationsErgebnisBuilder;
import simulation.SimulationsHelper.AuslastungsHelper;
import simulation.SimulationsHelper.BelegungsHelper;
import simulation.SimulationsHelper.UeberbuchungsHelper;
import simulation.SimulationsService;
import simulation.exceptions.PruefungsException;
import simulation.exceptions.SimulationsException;
import tec.uom.se.ComparableQuantity;
import util.Pair;
import zeit.eintraege.BelegungsEintrag;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.MenschBelegungEintrag;

public class SimulationsServiceImpl
implements SimulationsService {
    private final UeberbuchungsHelper uerbuchungsHelper;
    private final AuslastungsHelper auslastungsHelper;
    private final BelegungsHelper belegungsHelper;

    public SimulationsServiceImpl(ChronoUnit berechnungsZeitEinheit) {
        this.auslastungsHelper = AuslastungsHelper.create(berechnungsZeitEinheit);
        this.uerbuchungsHelper = UeberbuchungsHelper.create();
        this.belegungsHelper = BelegungsHelper.create();
    }

    public SimulationsServiceImpl() {
        this.auslastungsHelper = AuslastungsHelper.create();
        this.uerbuchungsHelper = UeberbuchungsHelper.create();
        this.belegungsHelper = BelegungsHelper.create();
    }

    @Override
    public PruefErgebnis pruefeProduktionsplanung(Collection<MaterialMitMessung<?>> verfuegbaresMaterial, ErmittelteBelegungen ermittelteBelegungen) {
        PruefErgebnisBuilder pruefErgebnisBuilder = PruefErgebnis.builder();
        pruefErgebnisBuilder.gepruefeBelegungen(ermittelteBelegungen).ueberbuchteMitarbeiter(this.uerbuchungsHelper.ermittleUeberbuchteMitarbeiter(ermittelteBelegungen)).ueberbuchteMaschinen(this.uerbuchungsHelper.ermittleUeberbuchteMaschinen(ermittelteBelegungen)).produktionsAuftraegeMitFehlendenBelegungen(this.ermittleProduktionsAuftraegeMitFehlendenBelegungenFuerDasProzessmodell(ermittelteBelegungen)).verbrauchtesMaterial(this.ermittleVerbrauchtesMaterial(this.ermittleBearbeiteteProduktionsauftraege(ermittelteBelegungen))).verfuegbaresMaterial(verfuegbaresMaterial);
        Pair<Collection<MaschinenBelegungEintrag>, Collection<MenschBelegungEintrag>> fehlendeBelegungen = this.belegungsHelper.ermittleFehlendeBelegungen(ermittelteBelegungen);
        pruefErgebnisBuilder.maschinenbelegungenOhneMitarbeiterbelegung((Collection)fehlendeBelegungen.getFirst()).mitarbeiterbelegungenOhneMaschinenbelegung((Collection)fehlendeBelegungen.getSecond()).fehlendeFaehigkeitenFuerBelegungenProMitarbeiter(this.ermittleFehlendeFaehigkeitenProMitarbeiter(ermittelteBelegungen));
        return pruefErgebnisBuilder.build();
    }

    @Override
    public SimulationsErgebnis simuliereProduktionsplanung(PruefErgebnis pruefErgebnis) {
        if (!pruefErgebnis.pruefungWarFehlerfrei()) {
            throw new PruefungsException(pruefErgebnis);
        }
        ErmittelteBelegungen ermittelteBelegungen = pruefErgebnis.getGepruefteBelegungen();
        SimulationsErgebnisBuilder simulationsErgebnisBuilder = SimulationsErgebnis.builder().pruefErgebnis(pruefErgebnis);
        simulationsErgebnisBuilder.verbrauchteZeitProProduktionsAuftrag(this.simuliereZeit(ermittelteBelegungen)).auslastungProMitarbeiter(this.auslastungsHelper.simuliereAuslastungProMitarbeiter(ermittelteBelegungen)).auslastungProMaschine(this.auslastungsHelper.simuliereAuslastungProMaschine(ermittelteBelegungen)).nichtEingehalteneSlas(this.simuliereEinhaltungDerSlas(ermittelteBelegungen));
        return simulationsErgebnisBuilder.build();
    }

    @Override
    public SimulationsErgebnis pruefeUndSimuliereProduktionsplanung(Collection<MaterialMitMessung<?>> verfuegbaresMaterial, ErmittelteBelegungen ermittelteBelegungen) {
        return this.simuliereProduktionsplanung(this.pruefeProduktionsplanung(verfuegbaresMaterial, ermittelteBelegungen));
    }

    private Collection<Dokumentenklasse> simuliereEinhaltungDerSlas(ErmittelteBelegungen ermittelteBelegungen) {
        Collection dokumentenklassenSLANichtEingehalten = ermittelteBelegungen.getMitarbeiterbelegungen().values().stream().flatMap(mitarbeiterBelegung -> mitarbeiterBelegung.getBelegung().stream()).flatMap(this.mapToEndezeitpunktProDokumentenklassen()).filter(this::wirdSlaNichtEingehalten).map(Pair::getSecond).collect(Collectors.toSet());
        dokumentenklassenSLANichtEingehalten.addAll(ermittelteBelegungen.getNichtZugeordneteProduktionsauftraege().stream().flatMap(produktionsAuftrag -> produktionsAuftrag.getDokumentenklassen().stream()).collect(Collectors.toSet()));
        return dokumentenklassenSLANichtEingehalten;
    }

    private Function<MenschBelegungEintrag, Stream<? extends Pair<LocalDateTime, Dokumentenklasse>>> mapToEndezeitpunktProDokumentenklassen() {
        return menschBelegungEintrag -> menschBelegungEintrag.getZuVerarbeitenderAuftrag().getDokumentenklassen().stream().map(dokumentenklasse -> Pair.create((Object)menschBelegungEintrag.getBis(), (Object)dokumentenklasse));
    }

    private boolean wirdSlaNichtEingehalten(Pair<LocalDateTime, Dokumentenklasse> fertigstellungenDerDokumentenklassen) {
        LocalDateTime slaFrist = ((Dokumentenklasse)fertigstellungenDerDokumentenklassen.getSecond()).getSla().getFrist((Dokumentenklasse)fertigstellungenDerDokumentenklassen.getSecond());
        return ((LocalDateTime)fertigstellungenDerDokumentenklassen.getFirst()).isAfter(slaFrist);
    }

    private Collection<MaterialMitMessung<?>> ermittleVerbrauchtesMaterial(Set<ProduktionsAuftrag> produktionsauftraege) {
        Map<Material, Quantity> verbrauchtesMaterial = produktionsauftraege.stream().map(ProduktionsAuftrag::getBenoetigteMaterialien).flatMap(Collection::stream).collect(SimulationsServiceImpl.groupByAndMapAndReduceValue(MaterialMitMessung::getMaterial, MaterialMitMessung::getMessung, Quantity::add));
        ArrayList result = new ArrayList();
        for (Map.Entry<Material, Quantity> messungProMaterial : verbrauchtesMaterial.entrySet()) {
            result.add(MaterialMitMessung.create((Material)messungProMaterial.getKey(), (Quantity)messungProMaterial.getValue()));
        }
        return result;
    }

    private Set<ProduktionsAuftrag> ermittleBearbeiteteProduktionsauftraege(ErmittelteBelegungen ermittelteBelegungen) {
        return ermittelteBelegungen.getMaschinenbelegungen().values().stream().flatMap(maschinenBelegung -> maschinenBelegung.getBelegung().stream()).map(BelegungsEintrag::getZuVerarbeitenderAuftrag).collect(Collectors.toSet());
    }

    private static <A, B, C> Collector<A, ?, Map<B, C>> groupByAndMapAndReduceValue(Function<A, B> groupingBy, Function<A, C> mapping, BinaryOperator<C> reducing) {
        return Collectors.groupingBy(groupingBy, Collectors.collectingAndThen(Collectors.mapping(mapping, Collectors.reducing(reducing)), optional -> optional.orElseThrow(() -> new SimulationsException("Should not happen. Optional bei groupReduce nicht present."))));
    }

    private Map<ProduktionsAuftrag, ComparableQuantity<Time>> simuliereZeit(ErmittelteBelegungen ermittelteBelegungen) {
        return ermittelteBelegungen.getMaschinenbelegungen().values().stream().flatMap(belegung -> belegung.getBelegung().stream()).collect(SimulationsServiceImpl.groupByAndMapAndReduceValue(BelegungsEintrag::getZuVerarbeitenderAuftrag, KalenderEintrag::getDauer, ComparableQuantity::add));
    }

    private Map<Mitarbeiter, Collection<MenschBelegungEintrag>> ermittleFehlendeFaehigkeitenProMitarbeiter(ErmittelteBelegungen ermittelteBelegungen) {
        HashMap<Mitarbeiter, Collection<MenschBelegungEintrag>> result = new HashMap<Mitarbeiter, Collection<MenschBelegungEintrag>>();
        for (Mitarbeiter mitarbeiter : ermittelteBelegungen.getMitarbeiterbelegungen().keySet()) {
            Set belegungen = ermittelteBelegungen.getMitarbeiterbelegungen().get(mitarbeiter).getBelegung().stream().filter(menschBelegungEintrag -> !mitarbeiter.kannMaschineBedienen(menschBelegungEintrag.getMaschineDieBedientWird())).collect(Collectors.toSet());
            if (belegungen.isEmpty()) continue;
            result.put(mitarbeiter, belegungen);
        }
        return result;
    }

    private Collection<ProduktionsAuftrag> ermittleProduktionsAuftraegeMitFehlendenBelegungenFuerDasProzessmodell(ErmittelteBelegungen ermittelteBelegungen) {
        Map<ProduktionsAuftrag, List<MenschBelegungEintrag>> belegungenProProduktionsauftrag = ermittelteBelegungen.getMitarbeiterbelegungen().values().stream().flatMap(mitarbeiterBelegung -> mitarbeiterBelegung.getBelegung().stream()).collect(Collectors.groupingBy(BelegungsEintrag::getZuVerarbeitenderAuftrag));
        return belegungenProProduktionsauftrag.entrySet().stream().filter(produktionsAuftrag -> !this.pruefeBelegungenPassenZuProzessmodell((Map.Entry<ProduktionsAuftrag, List<MenschBelegungEintrag>>)produktionsAuftrag)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private boolean pruefeBelegungenPassenZuProzessmodell(Map.Entry<ProduktionsAuftrag, List<MenschBelegungEintrag>> produktionsAuftragListEntry) {
        return this.hatPassendeBelegung(produktionsAuftragListEntry.getKey().getProzessModell(), new ArrayList<MenschBelegungEintrag>((Collection)produktionsAuftragListEntry.getValue()));
    }

    private boolean hatPassendeBelegung(ProzessModell prozessModell, Collection<MenschBelegungEintrag> alleBelegungen) {
        Set vorhandeneFaehigkeiten = alleBelegungen.stream().map(belegung -> belegung.getMaschineDieBedientWird().getMaschinentyp().getMaschinenFaehigkeit()).collect(Collectors.toSet());
        if (prozessModell.getFaehigkeiten().isEmpty()) {
            return true;
        }
        return prozessModell.getFaehigkeiten().stream().allMatch(geforderteFaehigkeit -> vorhandeneFaehigkeiten.stream().anyMatch(vorhandeneFaehigkeit -> vorhandeneFaehigkeit.erfuellt(geforderteFaehigkeit)));
    }
}

