/*
 * Decompiled with CFR 0.152.
 */
package zeit.eintraege;

import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameter;
import auftraege.auftragsBildungsParameter.abstraction.AusschliessenderParameterVisitor;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import javax.measure.quantity.Time;
import tec.uom.se.ComparableQuantity;
import zeit.ZeitUtils;

public final class Zeitraum
implements AusschliessenderParameter {
    static final int BEFORE_MIDNIGHT_HOUR = 23;
    static final int BEFORE_MIDNIGHT_MINUTE = 59;
    static final int BEFORE_MIDNIGHT_SECOND = 59;
    private final LocalDateTime von;
    private final LocalDateTime bis;

    private Zeitraum(LocalDateTime von, LocalDateTime bis) {
        this.von = von;
        this.bis = bis;
    }

    public static Zeitraum create(LocalDateTime von, ComparableQuantity<Time> dauer) {
        return new Zeitraum(von, ZeitUtils.addTime(von, dauer));
    }

    public static Zeitraum create(LocalDateTime von, LocalDateTime bis) {
        if (von.isAfter(bis)) {
            throw new IllegalArgumentException(String.format("Der Anfangszeitpunkt eines Zeitraumes muss vor dem Endzeitpunk des Zeitraumes liegen! [%s] <--> [%s]", von, bis));
        }
        return new Zeitraum(von, bis);
    }

    public static Zeitraum create(LocalDate von, LocalDate bis) {
        return Zeitraum.create(von.atStartOfDay(), bis.atTime(LocalTime.MAX));
    }

    public static Zeitraum createWholeDay(LocalDate tag) {
        return Zeitraum.create(tag.atStartOfDay(), tag.atTime(23, 59, 59));
    }

    public boolean contains(LocalDateTime zeitpunkt) {
        return this.getVon().isEqual(zeitpunkt) || this.getBis().isEqual(zeitpunkt) || this.getBis().isAfter(zeitpunkt) && this.getVon().isBefore(zeitpunkt);
    }

    public boolean contains(Zeitraum zeitraum) {
        return this.contains(zeitraum.getVon()) && this.contains(zeitraum.getBis());
    }

    public boolean ueberschneidet(Zeitraum zeitraum) {
        return this.contains(zeitraum.getVon()) || this.contains(zeitraum.getBis()) || zeitraum.contains(this.getVon()) || zeitraum.contains(this.getBis());
    }

    public LocalDateTime getVon() {
        return this.von;
    }

    public ComparableQuantity<Time> getDauer() {
        return ZeitUtils.calcTimeBetween(this.von, this.bis);
    }

    public LocalDateTime getBis() {
        return this.bis;
    }

    public Collection<Zeitraum> subtract(Zeitraum zeitraum) {
        if (zeitraum.contains(this) && !this.equals(zeitraum)) {
            return Collections.emptySet();
        }
        if (this.keineUeberschneidungAusserPunktuell(zeitraum)) {
            return Collections.singleton(this);
        }
        HashSet<Zeitraum> zeitraeume = new HashSet<Zeitraum>();
        if (this.getVon().isBefore(zeitraum.getVon())) {
            zeitraeume.add(Zeitraum.create(this.getVon(), zeitraum.getVon()));
        }
        if (zeitraum.getBis().isBefore(this.getBis())) {
            zeitraeume.add(Zeitraum.create(zeitraum.getBis(), this.getBis()));
        }
        return zeitraeume;
    }

    public boolean keineUeberschneidungAusserPunktuell(Zeitraum zeitraum) {
        return zeitraum.getBis().isBefore(this.getVon()) || zeitraum.getVon().isAfter(this.getBis());
    }

    public Set<Zeitraum> entferneZeitraeume(Collection<Zeitraum> abwesenheiten) {
        if (abwesenheiten.isEmpty()) {
            return Collections.singleton(this);
        }
        HashSet<Zeitraum> entstehendeZeitraeume = new HashSet<Zeitraum>();
        Zeitraum abwesenheit = abwesenheiten.stream().findAny().get();
        Collection<Zeitraum> neueZeitraeume = this.subtract(abwesenheit);
        for (Zeitraum neuerZeitraum : neueZeitraeume) {
            HashSet<Zeitraum> abwesenheitenReduziert = new HashSet<Zeitraum>(abwesenheiten);
            abwesenheitenReduziert.remove(abwesenheit);
            entstehendeZeitraeume.addAll(neuerZeitraum.entferneZeitraeume(abwesenheitenReduziert));
        }
        return entstehendeZeitraeume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Zeitraum)) {
            return false;
        }
        Zeitraum zeitraum = (Zeitraum)o;
        if (!this.von.equals(zeitraum.von)) {
            return false;
        }
        return this.bis.equals(zeitraum.bis);
    }

    public int hashCode() {
        int result = this.von.hashCode();
        result = 31 * result + this.bis.hashCode();
        return result;
    }

    public String toString() {
        return "Zeitraum{von=" + this.von + ", bis=" + this.bis + '}';
    }

    @Override
    public <T> T accept(AusschliessenderParameterVisitor<T> v) {
        return v.handle(this);
    }

    public Collection<Zeitraum> splitInEinzelneTage() {
        Zeitraum zeitraum = Zeitraum.create(this.getVon(), this.getBis());
        LinkedList<Zeitraum> gelieferteZeitraeume = new LinkedList<Zeitraum>();
        while (!zeitraum.getVon().toLocalDate().isEqual(zeitraum.getBis().toLocalDate())) {
            zeitraum = Zeitraum.create(zeitraum.getVon(), zeitraum.getVon().toLocalDate().atTime(LocalTime.MAX));
            gelieferteZeitraeume.add(zeitraum);
            zeitraum = Zeitraum.create(zeitraum.getVon().plusDays(1L).toLocalDate().atStartOfDay(), this.getBis());
        }
        gelieferteZeitraeume.add(zeitraum);
        return gelieferteZeitraeume;
    }

    public DayOfWeek getWochentag() {
        if (this.getVon().getDayOfWeek().equals(this.getBis().getDayOfWeek())) {
            return this.getVon().getDayOfWeek();
        }
        throw new IllegalStateException(String.format("Es handelt sich bei [%s] und [%s] nicht um denselben Tag!", this.getVon().toString(), this.getBis().toString()));
    }

    public Optional<Zeitraum> berechneUeberschneidung(Zeitraum zeitraum) {
        Zeitraum spaetererZeitraum;
        Zeitraum fruehererZeitraum;
        if (this.getVon().isBefore(zeitraum.getVon())) {
            fruehererZeitraum = this;
            spaetererZeitraum = zeitraum;
        } else {
            fruehererZeitraum = zeitraum;
            spaetererZeitraum = this;
        }
        if (fruehererZeitraum.getBis().isBefore(spaetererZeitraum.getVon()) || fruehererZeitraum.getBis().isEqual(spaetererZeitraum.getVon())) {
            return Optional.empty();
        }
        return Optional.of(Zeitraum.create(spaetererZeitraum.getVon(), fruehererZeitraum.getBis()));
    }
}

