/*
 * Decompiled with CFR 0.152.
 */
package mensch.faehigkeit;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import maschine.MaschinenTyp;
import mensch.faehigkeit.MitarbeiterFaehigkeit;
import mensch.faehigkeit.MitarbeiterFaehigkeitFuerMaschine;
import schnittstelle.Sitzung;
import util.exceptions.FaehigkeitsException;

public final class MitarbeiterFaehigkeitenManager {
    private final Collection<MitarbeiterFaehigkeit> faehigkeiten = new HashSet<MitarbeiterFaehigkeit>();

    private MitarbeiterFaehigkeitenManager() {
    }

    public static MitarbeiterFaehigkeitenManager getInstance() {
        MitarbeiterFaehigkeitenManager manager = Sitzung.getInstance().getMitarbeiterFaehigkeitenManager();
        if (manager == null) {
            Sitzung.getInstance().provideMitarbeiterFaehigkeitenManager(new MitarbeiterFaehigkeitenManager());
        }
        return Sitzung.getInstance().getMitarbeiterFaehigkeitenManager();
    }

    public MitarbeiterFaehigkeit createMitarbeiterFaehigkeitFuerMaschine(String name, String beschreibung) throws FaehigkeitsException {
        if (name.matches(".*Maschinenf\u00e4higkeit.*")) {
            throw new FaehigkeitsException(String.format("Name der F\u00e4higkeit %s nicht zugelassen. Es handelt sich nicht um eine Maschinenf\u00e4higkeit. Nicht-Maschinenf\u00e4higkeiten d\u00fcrfen nicht \"Maschinenf\u00e4higkeit\" hei\u00dfen.", name));
        }
        return this.getFaehigkeit(name, beschreibung);
    }

    public MitarbeiterFaehigkeitFuerMaschine createMitarbeiterFaehigkeitFuerMaschine(String name, String beschreibung, MaschinenTyp maschinentyp) {
        return this.getMaschinenFaehigkeit(name, beschreibung, maschinentyp);
    }

    private MitarbeiterFaehigkeitFuerMaschine getMaschinenFaehigkeit(String name, String beschreibung, MaschinenTyp maschinentyp) {
        MitarbeiterFaehigkeitFuerMaschine faehigkeit = new MitarbeiterFaehigkeitFuerMaschine(name, beschreibung, maschinentyp);
        return (MitarbeiterFaehigkeitFuerMaschine)this.faehigkeiten.stream().filter(mitarbeiterFaehigkeit -> mitarbeiterFaehigkeit.equals(faehigkeit)).findFirst().orElse(faehigkeit);
    }

    private MitarbeiterFaehigkeit getFaehigkeit(String name, String beschreibung) {
        Optional<MitarbeiterFaehigkeit> optionalFaehigkeit = this.getFaehigkeitIfExists(name, beschreibung);
        if (!optionalFaehigkeit.isPresent()) {
            MitarbeiterFaehigkeit mitarbeiterFaehigkeit = new MitarbeiterFaehigkeit(name, beschreibung);
            this.faehigkeiten.add(mitarbeiterFaehigkeit);
            return mitarbeiterFaehigkeit;
        }
        return optionalFaehigkeit.get();
    }

    private Optional<MitarbeiterFaehigkeit> getFaehigkeitIfExists(String name, String beschreibung) {
        return this.faehigkeiten.stream().filter(mitarbeiterFaehigkeit -> mitarbeiterFaehigkeit.getName().equals(name)).findFirst();
    }
}

