/*
 * Decompiled with CFR 0.152.
 */
package produktionsauftrag;

import auftraege.ProduktionsAuftrag;
import auftraege.ServiceLevelAgreement;
import auftraege.UnpassendeKlasseException;
import auftraege.auftragsBildungsParameter.BeilagenArten;
import auftraege.auftragsBildungsParameter.FarbDruckTypMischbar;
import auftraege.auftragsBildungsParameter.MaxBeilagenarten;
import auftraege.auftragsBildungsParameter.MaxKundenauftraege;
import auftraege.auftragsBildungsParameter.SimplexDuplexMischbar;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariable;
import auftraege.auftragsBildungsParameter.abstraction.DokumentenklassenVariablenVisitor;
import auftraege.auftragsBildungsParameter.abstraction.ProduktionsauftragsParameter;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.BlattAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Id;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.Kommentar;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.ProzessModell;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.SendungsAnzahl;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariable;
import auftraege.auftragsBildungsParameter.dokumentenKlassenVariablen.UnbekannteVariablen;
import auftraege.versand.Kunde;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import maschine.faehigkeit.DruckTyp;
import maschine.faehigkeit.FarbDruckTyp;
import material.auspraegungen.Papierformat;
import material.kuvert.KuvertFormat;
import produktionsauftrag.DokumentenklasseBuilder;
import produktionsauftrag.FaktorOutOfBoundsException;
import util.ClassObjectMap;
import util.exceptions.AlreadyExistsException;
import util.exceptions.SollteNichtPassierenException;

class ProduktionsauftragsBuilder {
    private final Map<DokumentenklasseBuilder, Double> dokumentenklassen;
    private final ClassObjectMap<DokumentenklassenVariable> kompatibilitaetsParameter;
    private final ClassObjectMap<ProduktionsauftragsParameter> produktionsauftragsParameter;

    ProduktionsauftragsBuilder(ClassObjectMap<ProduktionsauftragsParameter> produktionsauftragsParameter) {
        this.produktionsauftragsParameter = produktionsauftragsParameter;
        this.dokumentenklassen = new HashMap<DokumentenklasseBuilder, Double>();
        this.kompatibilitaetsParameter = new ClassObjectMap();
    }

    ProduktionsAuftrag baue() {
        return new ProduktionsAuftrag(this.dokumentenklassen.entrySet().stream().map(k -> ((DokumentenklasseBuilder)k.getKey()).baue((Double)k.getValue())).collect(Collectors.toList()));
    }

    private boolean hatPlatzfuerKlasse(DokumentenklasseBuilder klasse, double faktor) {
        if (!this.dokumentenklassen.containsKey(klasse)) {
            return true;
        }
        return faktor - (1.0 - this.dokumentenklassen.get(klasse)) <= 0.0;
    }

    Integer getBlattZahl() {
        return this.dokumentenklassen.entrySet().stream().mapToInt(k -> (int)((double)((DokumentenklasseBuilder)k.getKey()).getAnzahlBlaetter() * (Double)k.getValue())).sum();
    }

    public ServiceLevelAgreement getSla() {
        return this.dokumentenklassen.keySet().stream().min(Comparator.comparing(dokumentenklassenBuilder -> dokumentenklassenBuilder.getSla().getFrist(dokumentenklassenBuilder.getEingangszeitpunkt()))).map(DokumentenklasseBuilder::getSla).orElse(ServiceLevelAgreement.MAX_VALUE);
    }

    void addDokumentenklasse(DokumentenklasseBuilder klasse, double plusFaktor) throws AlreadyExistsException, FaktorOutOfBoundsException, UnpassendeKlasseException {
        if (plusFaktor <= 0.0 || plusFaktor > 1.0) {
            throw new FaktorOutOfBoundsException();
        }
        if (!this.hatPlatzfuerKlasse(klasse, plusFaktor)) {
            throw new AlreadyExistsException("Hier muss sich noch etwas sinnvolles \u00fcberlegt werden.");
        }
        if (this.dokumentenklassen.isEmpty()) {
            this.prepareKompatibitlitaetsParameter(klasse);
        } else if (!this.pruefeKompatibilitaet(klasse, true)) {
            throw new UnpassendeKlasseException();
        }
        Double faktor = this.dokumentenklassen.get(klasse);
        faktor = faktor == null ? plusFaktor : faktor + plusFaktor;
        this.dokumentenklassen.put(klasse, faktor);
        klasse.setBereitsEingeplanteBlaetter(klasse.getBereitsEingeplanteBlaetter() + (int)((double)klasse.getAnzahlBlaetter() * plusFaktor));
    }

    private void prepareKompatibitlitaetsParameter(DokumentenklasseBuilder klasse) {
        Set params = klasse.getVariablen().getBySuperclass(DokumentenklassenVariable.class);
        params.forEach(arg_0 -> this.kompatibilitaetsParameter.put(arg_0));
    }

    boolean pruefeKompatibilitaet(DokumentenklasseBuilder klasse) {
        return this.pruefeKompatibilitaet(klasse, false);
    }

    private boolean pruefeKompatibilitaet(DokumentenklasseBuilder klasse, boolean passeKompatibilitaetAn) {
        if (this.kompatibilitaetsParameter.isEmpty()) {
            if (passeKompatibilitaetAn) {
                this.prepareKompatibitlitaetsParameter(klasse);
            }
            return true;
        }
        if (this.dokumentenklassen.size() >= this.produktionsauftragsParameter.get(MaxKundenauftraege.class).map(MaxKundenauftraege::getValue).orElse(Integer.MAX_VALUE)) {
            return false;
        }
        ArrayList after = new ArrayList();
        Boolean pruefErgebnis = (klasse.getVariable(UnbekannteVariablen.class).isPresent() || this.dokumentenklassen.keySet().stream().map(d -> d.getVariable(UnbekannteVariablen.class)).noneMatch(Optional::isPresent)) && klasse.getVariablen().valueStream().map(dokumentenklassenVariable -> (Boolean)dokumentenklassenVariable.accept((DokumentenklassenVariablenVisitor)new DokumentenklassenVariablenVisitorImpl(after))).reduce(true, (current, rest) -> current != false && rest != false) != false;
        if (pruefErgebnis.booleanValue()) {
            after.forEach(Runnable::run);
        }
        return pruefErgebnis;
    }

    private class DokumentenklassenVariablenVisitorImpl
    implements DokumentenklassenVariablenVisitor<Boolean> {
        private final List<Runnable> after;

        DokumentenklassenVariablenVisitorImpl(List<Runnable> after) {
            this.after = after;
        }

        public Boolean handle(KuvertFormat kuvertFormat) {
            return ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.get(KuvertFormat.class).map(arg_0 -> kuvertFormat.equals(arg_0)).orElseGet(() -> {
                this.after.add(() -> ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.put((Object)kuvertFormat));
                return true;
            });
        }

        public Boolean handle(BeilagenArten beilagen) {
            Optional maxBeilagenarten = ProduktionsauftragsBuilder.this.produktionsauftragsParameter.get(MaxBeilagenarten.class);
            if (!maxBeilagenarten.isPresent()) {
                return true;
            }
            Set bereitsEingeplanteBeilagen = ProduktionsauftragsBuilder.this.dokumentenklassen.keySet().stream().map(d -> d.getVariablen().get(BeilagenArten.class)).map(beilagenarten -> beilagenarten.orElse(BeilagenArten.EMPTY).getBeilagenarten()).flatMap(Collection::stream).collect(Collectors.toSet());
            return Stream.concat(bereitsEingeplanteBeilagen.stream(), beilagen.getBeilagenarten().stream()).distinct().count() <= (long)maxBeilagenarten.map(MaxBeilagenarten::getBegrenzung).orElseThrow(SollteNichtPassierenException::new).intValue();
        }

        public Boolean handle(ProzessModell prozessModell) {
            return ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.get(ProzessModell.class).map(arg_0 -> ((ProzessModell)prozessModell).equals(arg_0)).orElseGet(() -> {
                this.after.add(() -> ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.put((Object)prozessModell));
                return true;
            });
        }

        public Boolean handle(DruckTyp druckTyp) {
            return ProduktionsauftragsBuilder.this.produktionsauftragsParameter.get(SimplexDuplexMischbar.class).isPresent() ? Boolean.valueOf(true) : ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.get(DruckTyp.class).map(arg_0 -> druckTyp.equals(arg_0)).orElseGet(() -> {
                this.after.add(() -> ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.put((Object)druckTyp));
                return true;
            });
        }

        public Boolean handle(FarbDruckTyp farbDruckTyp) {
            return ProduktionsauftragsBuilder.this.produktionsauftragsParameter.get(FarbDruckTypMischbar.class).isPresent() ? Boolean.valueOf(true) : ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.get(FarbDruckTyp.class).map(arg_0 -> farbDruckTyp.equals(arg_0)).orElseGet(() -> {
                this.after.add(() -> ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.put((Object)farbDruckTyp));
                return true;
            });
        }

        public Boolean handle(ServiceLevelAgreement serviceLevelAgreement) {
            return true;
        }

        public Boolean handle(Papierformat papierformat) {
            return ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.get(Papierformat.class).map(arg_0 -> papierformat.equals(arg_0)).orElseGet(() -> {
                this.after.add(() -> ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.put((Object)papierformat));
                return true;
            });
        }

        public Boolean handle(BlattAnzahl blattAnzahl) {
            return true;
        }

        public Boolean handle(Id id) {
            return true;
        }

        public Boolean handle(SendungsAnzahl sendungsAnzahl) {
            return true;
        }

        public Boolean handle(Kunde kunde) {
            return true;
        }

        public Boolean handle(UnbekannteVariable unbekannteVariable) {
            throw new SollteNichtPassierenException("Alle unbekannten Variablen sollten an dieser Stelle bereits herausgefiltert worden sein.");
        }

        public Boolean handle(UnbekannteVariablen unbekannteVariablen) {
            return ProduktionsauftragsBuilder.this.kompatibilitaetsParameter.get(UnbekannteVariablen.class).map(arg_0 -> ((UnbekannteVariablen)unbekannteVariablen).equals(arg_0)).orElse(false);
        }

        public Boolean handle(Kommentar kommentar) {
            return true;
        }
    }
}

