/*
 * Decompiled with CFR 0.152.
 */
package statistik;

import auftraege.ProduktionsAuftrag;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import maschine.Maschine;
import mensch.Mitarbeiter;
import statistik.StatCalcEmptyListException;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.unit.Units;
import util.Fraction;
import zeit.eintraege.KalenderEintrag;
import zeit.eintraege.KalenderEintragTyp;
import zeit.eintraege.MaschinenBelegungEintrag;
import zeit.eintraege.Zeitraum;

public final class StatCalc {
    private static final double SEKUNDE_ZU_STUNDE = 3600.0;

    private StatCalc() {
    }

    public static ComparableQuantity<Time> getVerbrauchteZeitInsgesamt(List<ProduktionsAuftrag> auftraege, Zeitraum zeitraum) throws StatCalcEmptyListException {
        if (auftraege.isEmpty()) {
            throw new StatCalcEmptyListException();
        }
        ComparableQuantity result = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (ProduktionsAuftrag current : auftraege) {
            for (MaschinenBelegungEintrag currentBelegung : current.getMaschinenBelegungen().values()) {
                if (!currentBelegung.getZeitraum().ueberschneidet(zeitraum)) continue;
                result = result.add(StatCalc.getUeberschneidungZeitraeume((KalenderEintrag)currentBelegung, zeitraum));
            }
        }
        return result;
    }

    private static ComparableQuantity<Time> getUeberschneidungZeitraeume(KalenderEintrag currentBelegung, Zeitraum zeitraum) {
        long minBis = Math.min(currentBelegung.getBis().toEpochSecond(ZoneOffset.UTC), zeitraum.getBis().toEpochSecond(ZoneOffset.UTC));
        long maxVon = Math.max(currentBelegung.getVon().toEpochSecond(ZoneOffset.UTC), zeitraum.getVon().toEpochSecond(ZoneOffset.UTC));
        return Quantities.getQuantity((Number)((double)(minBis - maxVon) / 3600.0), (Unit)Units.HOUR);
    }

    public static ComparableQuantity<Time> getVerbrauchteZeitMaschine(Maschine maschine, Zeitraum zeitraum) {
        ComparableQuantity result = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (KalenderEintrag current : maschine.getAlleEintraege(zeitraum, new KalenderEintragTyp[]{KalenderEintragTyp.BELEGT})) {
            result = result.add(StatCalc.getUeberschneidungZeitraeume(current, zeitraum));
        }
        return result;
    }

    public static ComparableQuantity<Time> getVerbrauchteZeitMaschinenpark(List<Maschine> maschinenpark, Zeitraum zeitraum) {
        ComparableQuantity result = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (Maschine current : maschinenpark) {
            result = result.add(StatCalc.getVerbrauchteZeitMaschine(current, zeitraum));
        }
        return result;
    }

    public static Fraction getAuslastungMaschinenpark(List<Maschine> maschinenpark, Zeitraum zeitraum) throws StatCalcEmptyListException {
        if (maschinenpark.isEmpty()) {
            throw new StatCalcEmptyListException();
        }
        ComparableQuantity<Time> zeit = StatCalc.getVerbrauchteZeitMaschinenpark(maschinenpark, zeitraum);
        ComparableQuantity verfuegbareZeit = zeitraum.getDauer().multiply((Number)maschinenpark.size());
        for (Maschine current : maschinenpark) {
            for (KalenderEintrag currentBelegung : current.getAlleEintraege(zeitraum, new KalenderEintragTyp[]{KalenderEintragTyp.WARTUNG})) {
                verfuegbareZeit = verfuegbareZeit.subtract(StatCalc.getUeberschneidungZeitraeume(currentBelegung, zeitraum));
            }
        }
        return Fraction.valueOf((Number)zeit.to(Units.SECOND).getValue().doubleValue()).divide(Fraction.valueOf((Number)verfuegbareZeit.to(Units.SECOND).getValue().doubleValue()));
    }

    public static Fraction getAuslastungMaschine(Maschine maschine, Zeitraum zeitraum) {
        ComparableQuantity verfuegbareZeit = zeitraum.getDauer();
        for (KalenderEintrag current : maschine.getAlleEintraege(zeitraum, new KalenderEintragTyp[]{KalenderEintragTyp.WARTUNG})) {
            verfuegbareZeit = verfuegbareZeit.subtract(StatCalc.getUeberschneidungZeitraeume(current, zeitraum));
        }
        return Fraction.valueOf((Number)StatCalc.getVerbrauchteZeitMaschine(maschine, zeitraum).to(Units.SECOND).getValue().doubleValue()).divide(Fraction.valueOf((Number)verfuegbareZeit.to(Units.SECOND).getValue().doubleValue()));
    }

    public static ComparableQuantity<Time> getVerbrauchteZeitMitarbeiter(Mitarbeiter mitarbeiter, Zeitraum zeitraum) {
        ComparableQuantity result = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (KalenderEintrag current : mitarbeiter.getAlleEintraege(zeitraum, new KalenderEintragTyp[]{KalenderEintragTyp.BELEGT})) {
            result = result.add(StatCalc.getUeberschneidungZeitraeume(current, zeitraum));
        }
        return result;
    }

    public static ComparableQuantity<Time> getVerbrauchteZeitPersonal(List<Mitarbeiter> personal, Zeitraum zeitraum) {
        ComparableQuantity result = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (Mitarbeiter current : personal) {
            result = result.add(StatCalc.getVerbrauchteZeitMitarbeiter(current, zeitraum));
        }
        return result;
    }

    public static Fraction getAuslastungMitarbeiter(Mitarbeiter mitarbeiter, Zeitraum zeitraum) {
        ComparableQuantity verfuegbareZeit = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (KalenderEintrag current : mitarbeiter.getAlleEintraege(zeitraum, new KalenderEintragTyp[]{KalenderEintragTyp.ANWESEND})) {
            verfuegbareZeit = verfuegbareZeit.add(StatCalc.getUeberschneidungZeitraeume(current, zeitraum));
        }
        return Fraction.valueOf((Number)StatCalc.getVerbrauchteZeitMitarbeiter(mitarbeiter, zeitraum).to(Units.SECOND).getValue().doubleValue()).divide(Fraction.valueOf((Number)verfuegbareZeit.to(Units.SECOND).getValue().doubleValue()));
    }

    public static Fraction getAuslastungPersonal(List<Mitarbeiter> personal, Zeitraum zeitraum) throws StatCalcEmptyListException {
        if (personal.isEmpty()) {
            throw new StatCalcEmptyListException();
        }
        ComparableQuantity<Time> zeit = StatCalc.getVerbrauchteZeitPersonal(personal, zeitraum);
        ComparableQuantity verfuegbareZeit = Quantities.getQuantity((Number)0, (Unit)Units.HOUR);
        for (Mitarbeiter current : personal) {
            for (KalenderEintrag currentBelegung : current.getAlleEintraege(zeitraum, new KalenderEintragTyp[]{KalenderEintragTyp.ANWESEND})) {
                verfuegbareZeit = verfuegbareZeit.add(StatCalc.getUeberschneidungZeitraeume(currentBelegung, zeitraum));
            }
        }
        return Fraction.valueOf((Number)zeit.to(Units.SECOND).getValue().doubleValue()).divide(Fraction.valueOf((Number)verfuegbareZeit.to(Units.SECOND).getValue().doubleValue()));
    }

    public static int getAnzahlUeberschreitungenSLA(List<ProduktionsAuftrag> auftraege) throws StatCalcEmptyListException {
        if (auftraege.isEmpty()) {
            throw new StatCalcEmptyListException();
        }
        ArrayList<ProduktionsAuftrag> result = new ArrayList<ProduktionsAuftrag>();
        for (ProduktionsAuftrag current : auftraege) {
            for (MaschinenBelegungEintrag currentBelegung : current.getMaschinenBelegungen().values()) {
                if (!currentBelegung.getBis().isAfter(current.getFrist())) continue;
                result.add(current);
            }
        }
        return result.size();
    }
}

