/*
 * Decompiled with CFR 0.152.
 */
package material.auspraegungen;

import java.util.Objects;
import javax.measure.quantity.Volume;
import material.Auspraegung;
import material.Material;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class Farbe
extends Auspraegung<Farbe>
implements Material<Volume> {
    private static final int RGB_MAX = 255;
    private final int red;
    private final int green;
    private final int blue;

    public Farbe(int red, int green, int blue) {
        super(Farbe.class);
        Assert.assertThat((Object)red, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)red, (Matcher)CoreMatchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(255))));
        Assert.assertThat((Object)green, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)green, (Matcher)CoreMatchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(255))));
        Assert.assertThat((Object)blue, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)blue, (Matcher)CoreMatchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(255))));
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static Farbe parse(String farbeAsString) {
        switch (farbeAsString.toLowerCase().trim()) {
            case "wei\u00df": {
                return new Farbe(255, 255, 255);
            }
            case "schwarz": {
                return new Farbe(0, 0, 0);
            }
        }
        throw new RuntimeException(String.format("Farbe %s nicht bekannt", farbeAsString));
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Farbe farbe = (Farbe)o;
        return this.red == farbe.red && this.green == farbe.green && this.blue == farbe.blue;
    }

    public int hashCode() {
        return Objects.hash(this.red, this.green, this.blue);
    }

    @Override
    public Auspraegung<Farbe> getAuspraegung() {
        return this;
    }
}

